/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.semantic;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.semantic.Tag;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class CudamiTagsClient
extends CudamiRestClient<Tag> {
    public CudamiTagsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Tag.class, mapper, "/v6/tags");
    }

    public Tag getByValue(String value) throws TechnicalException {
        String encodedValue = Base64.encodeBase64URLSafeString((byte[])value.getBytes(StandardCharsets.UTF_8));
        try {
            return (Tag)this.doGetRequestForObject(String.format(this.baseEndpoint + "/value/%s", encodedValue));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }
}

