/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.lobid.client.LobidBaseClient;
import de.digitalcollections.cudami.lobid.client.model.LobidCorporateBody;
import de.digitalcollections.cudami.lobid.client.model.LobidDepiction;
import de.digitalcollections.cudami.lobid.client.model.LobidHomepage;
import de.digitalcollections.model.api.http.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Corporation;
import de.digitalcollections.model.api.identifiable.parts.LocalizedText;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.CorporationImpl;
import de.digitalcollections.model.impl.identifiable.parts.LocalizedTextImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobidCorporationsClient
extends LobidBaseClient<LobidCorporateBody> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LobidCorporationsClient.class);

    LobidCorporationsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, LobidCorporateBody.class, mapper);
    }

    public Corporation getByGndId(String gndId) throws HttpException {
        LobidCorporateBody lobidCorporateBody = (LobidCorporateBody)this.doGetRequestForObject(String.format("/gnd/%s.json", gndId));
        Corporation corporation = this.mapLobidToModel(lobidCorporateBody);
        return corporation;
    }

    private Corporation mapLobidToModel(LobidCorporateBody lobidCorporateBody) {
        List<LobidDepiction> depiction;
        List<LobidHomepage> homepage;
        CorporationImpl corporation = new CorporationImpl();
        Object labelText = lobidCorporateBody.getPreferredName();
        List<String> abbreviatedNameForTheCorporateBody = lobidCorporateBody.getAbbreviatedNameForTheCorporateBody();
        if (labelText != null && abbreviatedNameForTheCorporateBody != null) {
            labelText = (String)labelText + " (" + abbreviatedNameForTheCorporateBody.get(0) + ")";
        }
        corporation.setLabel((LocalizedText)new LocalizedTextImpl(Locale.GERMAN, (String)labelText));
        String gndIdentifier = lobidCorporateBody.getGndIdentifier();
        if (gndIdentifier != null) {
            corporation.addIdentifier((Identifier)new IdentifierImpl(null, "gnd", gndIdentifier));
        }
        if ((homepage = lobidCorporateBody.getHomepage()) != null && !homepage.isEmpty()) {
            String homepageId = homepage.get(0).getId();
            try {
                corporation.setHomepageUrl(URI.create(homepageId).toURL());
            }
            catch (MalformedURLException ex) {
                LOGGER.warn("Invalid homepage URL: " + homepageId);
            }
        }
        if ((depiction = lobidCorporateBody.getDepiction()) != null && !depiction.isEmpty()) {
            String thumbnailUrl = depiction.get(0).getThumbnail();
            ImageFileResourceImpl previewImage = new ImageFileResourceImpl();
            previewImage.setUri(URI.create(thumbnailUrl));
            previewImage.setMimeType(MimeType.MIME_IMAGE);
            corporation.setPreviewImage((ImageFileResource)previewImage);
        }
        return corporation;
    }
}

