/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.lobid.client.LobidCorporateBodiesClient;
import de.digitalcollections.cudami.lobid.client.LobidEventsClient;
import de.digitalcollections.cudami.lobid.client.LobidGeoLocationsClient;
import de.digitalcollections.cudami.lobid.client.LobidHumanSettlementsClient;
import de.digitalcollections.cudami.lobid.client.LobidPersonsClient;
import de.digitalcollections.cudami.lobid.client.LobidSubjectsClient;
import de.digitalcollections.cudami.lobid.client.LobidWorksClient;
import de.digitalcollections.lobid.jackson.LobidObjectMapper;
import java.net.http.HttpClient;
import java.time.Duration;

public class LobidClient {
    protected final HttpClient http;
    private final LobidCorporateBodiesClient lobidCorporateBodiesClient;
    private final LobidEventsClient lobidEventsClient;
    private final LobidGeoLocationsClient lobidGeoLocationsClient;
    private final LobidHumanSettlementsClient lobidHumanSettlementsClient;
    private final LobidPersonsClient lobidPersonsClient;
    private final LobidSubjectsClient lobidSubjectsClient;
    private final LobidWorksClient lobidWorksClient;

    public LobidClient() {
        this("https://lobid.org", (ObjectMapper)new LobidObjectMapper());
    }

    public LobidClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        this.http = http;
        this.lobidCorporateBodiesClient = new LobidCorporateBodiesClient(http, serverUrl, mapper);
        this.lobidEventsClient = new LobidEventsClient(http, serverUrl, mapper);
        this.lobidGeoLocationsClient = new LobidGeoLocationsClient(http, serverUrl, mapper);
        this.lobidHumanSettlementsClient = new LobidHumanSettlementsClient(http, serverUrl, mapper);
        this.lobidPersonsClient = new LobidPersonsClient(http, serverUrl, mapper);
        this.lobidSubjectsClient = new LobidSubjectsClient(http, serverUrl, mapper);
        this.lobidWorksClient = new LobidWorksClient(http, serverUrl, mapper);
    }

    public LobidClient(String serverUrl, ObjectMapper mapper) {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofSeconds(10L)).build(), serverUrl, mapper);
    }

    public LobidCorporateBodiesClient forCorporateBodies() {
        return this.lobidCorporateBodiesClient;
    }

    public LobidEventsClient forEvents() {
        return this.lobidEventsClient;
    }

    public LobidGeoLocationsClient forGeoLocations() {
        return this.lobidGeoLocationsClient;
    }

    public LobidHumanSettlementsClient forHumanSettlements() {
        return this.lobidHumanSettlementsClient;
    }

    public LobidPersonsClient forPersons() {
        return this.lobidPersonsClient;
    }

    public LobidSubjectsClient forSubjects() {
        return this.lobidSubjectsClient;
    }

    public LobidWorksClient forWorks() {
        return this.lobidWorksClient;
    }
}

