/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.lobid.client.mapper;

import de.digitalcollections.model.time.TimeValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Locale;

public class DateUtil {
    public static LocalDate extractFilledStartDate(String dateString) {
        return DateUtil.extractFilledDate(dateString, 1, 1);
    }

    public static LocalDate extractFilledEndDate(String dateString) {
        return DateUtil.extractFilledDate(dateString, 12, 31);
    }

    private static LocalDate extractFilledDate(String dateString, int monthIfNotGiven, int dayIfNotGiven) {
        String filledDateString;
        if (dateString == null || dateString.isBlank()) {
            return null;
        }
        boolean isBC = dateString.startsWith("-");
        try {
            String[] dateStringParts = dateString.replaceFirst("^-", "").split("-");
            switch (dateStringParts.length) {
                case 1: {
                    int year = Integer.parseInt(dateStringParts[0]);
                    filledDateString = String.format("%04d-%02d-%02d %s", year, monthIfNotGiven, dayIfNotGiven, isBC ? "BC" : "AD");
                    break;
                }
                case 2: {
                    int year = Integer.parseInt(dateStringParts[0]);
                    int month = Integer.parseInt(dateStringParts[1]);
                    int day = Math.min(dayIfNotGiven, DateUtil.maxDayInMonth(year, month));
                    filledDateString = String.format("%04d-%02d-%02d %s", year, month, day, isBC ? "BC" : "AD");
                    break;
                }
                case 3: {
                    filledDateString = String.format("%s %s", dateString, isBC ? "BC" : "AD");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid date='" + dateString + "' detected. Giving up here.");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse date='" + dateString + "'", e);
        }
        return LocalDate.parse(filledDateString, DateTimeFormatter.ofPattern("yyyy-MM-dd GG", Locale.ROOT));
    }

    private static int maxDayInMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(2, month - 1);
        cal.set(1, year);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, cal.getActualMaximum(5));
        return cal.get(5);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="We really want to catch any error")
    public static TimeValue extractTimeValue(String dateString, byte leastPrecision) throws ParseException {
        if (dateString == null || dateString.isBlank()) {
            return null;
        }
        try {
            TimeValue tv;
            boolean yearBC = false;
            if (dateString.startsWith("-")) {
                yearBC = true;
                dateString = dateString.substring(1);
            }
            String[] parts = dateString.split("-");
            switch (parts.length) {
                case 1: {
                    tv = new TimeValue((long)(Integer.parseInt(parts[0]) * (yearBC ? -1 : 1)));
                    tv.setPrecision(leastPrecision);
                    break;
                }
                case 2: {
                    tv = new TimeValue(Long.parseLong(parts[0]) * (long)(yearBC ? -1 : 1), Byte.parseByte(parts[1]), 0);
                    tv.setPrecision((byte)10);
                    break;
                }
                case 3: {
                    tv = new TimeValue(Long.parseLong(parts[0]) * (long)(yearBC ? -1 : 1), Byte.parseByte(parts[1]), Byte.parseByte(parts[2]));
                    tv.setPrecision((byte)11);
                    break;
                }
                default: {
                    throw new ParseException("Unknown format for date='" + dateString + "'", 0);
                }
            }
            return tv;
        }
        catch (Exception e) {
            throw new ParseException("Invalid format for date='" + dateString + "'", 0);
        }
    }
}

