/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.model.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.digitalcollections.core.model.jackson.DcCoreModelModule;
import de.digitalcollections.cudami.model.jackson.CudamiModule;
import de.digitalcollections.prosemirror.model.jackson.ProseMirrorModule;

public class CudamiObjectMapper
extends ObjectMapper {
    public CudamiObjectMapper() {
        CudamiObjectMapper.customize(this);
    }

    public static ObjectMapper customize(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new DcCoreModelModule());
        objectMapper.registerModule((Module)new CudamiModule());
        objectMapper.registerModule((Module)new ProseMirrorModule());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper;
    }
}

