/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.model.impl.identifiable.parts;

import de.digitalcollections.cudami.model.api.identifiable.parts.Text;
import de.digitalcollections.cudami.model.api.identifiable.parts.Translation;
import de.digitalcollections.cudami.model.impl.identifiable.parts.TranslationImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class TextImpl
implements Text {
    private Set<Translation> translations = new HashSet<Translation>();

    public TextImpl() {
    }

    public TextImpl(Locale locale, String text) {
        this();
        this.translations.add(new TranslationImpl(locale, text));
    }

    public TextImpl(List<Locale> locales, String text) {
        this();
        for (Locale locale : locales) {
            this.translations.add(new TranslationImpl(locale, text));
        }
    }

    public TextImpl(Text text) {
        this();
        for (Translation translation : text.getTranslations()) {
            this.translations.add(new TranslationImpl(translation.getLocale(), translation.getText()));
        }
    }

    private Translation findTranslation(Locale locale) {
        for (Translation translation : this.translations) {
            if (!translation.has(locale)) continue;
            return translation;
        }
        return null;
    }

    @Override
    public Collection<Locale> getLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        for (Translation translation : this.translations) {
            locales.add(translation.getLocale());
        }
        return locales;
    }

    @Override
    public String getText() {
        Collection<Locale> locales = this.getLocales();
        if (locales.isEmpty()) {
            return null;
        }
        return this.getText(locales.iterator().next());
    }

    @Override
    public String getText(Locale locale) {
        Translation translation = this.findTranslation(locale);
        if (translation != null) {
            return translation.getText();
        }
        return this.getText();
    }

    @Override
    public void setText(Locale locale, String text) {
        Translation translation = this.findTranslation(locale);
        if (translation != null) {
            translation.setText(text);
        } else {
            this.translations.add(new TranslationImpl(locale, text));
        }
    }

    @Override
    public Set<Translation> getTranslations() {
        return this.translations;
    }

    @Override
    public void setTranslations(Set<Translation> translations) {
        this.translations = translations;
    }
}

