/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.model.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CudamiConfig {
    private Defaults defaults;
    private UrlAlias urlAlias;
    private int offsetForAlternativePaging = 0;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public CudamiConfig(@JsonProperty(value="defaults") Defaults defaults, @JsonProperty(value="urlAlias") UrlAlias urlAlias, @JsonProperty(value="offsetForAlternativePaging") int offsetForAlternativePaging) {
        this.defaults = defaults;
        this.urlAlias = urlAlias;
        this.offsetForAlternativePaging = offsetForAlternativePaging;
    }

    public Defaults getDefaults() {
        return this.defaults;
    }

    public UrlAlias getUrlAlias() {
        return this.urlAlias;
    }

    public int getOffsetForAlternativePaging() {
        return this.offsetForAlternativePaging;
    }

    public static class UrlAlias {
        private static final int DB_MAX_LENGTH = 256;
        private List<String> generationExcludes;
        private int maxLength = -1;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_RUNTIMEEXCEPTION"}, justification="Application must not start with an invalid configuration")
        public UrlAlias(@JsonProperty(value="generationExcludes") List<String> generationExcludes, @JsonProperty(value="maxLength") int maxLength) {
            List<String> list = this.generationExcludes = generationExcludes != null ? List.copyOf(generationExcludes) : Collections.EMPTY_LIST;
            if (maxLength > 256) {
                throw new RuntimeException("The maxLength you configured is invalid, because it is greater than 256 (this is the greatest possible length in the database)!");
            }
            this.maxLength = maxLength;
        }

        public List<String> getGenerationExcludes() {
            return List.copyOf(this.generationExcludes);
        }

        public int getMaxLength() {
            return this.maxLength;
        }
    }

    public static class Defaults {
        private String language;
        private Locale locale;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        public Defaults(@JsonProperty(value="language") String language, @JsonProperty(value="locale") Locale locale) {
            this.language = language;
            this.locale = locale;
        }

        public String getLanguage() {
            return this.language;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

