/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public interface CollectionRepository
extends NodeRepository<Collection>,
EntityRepository<Collection> {
    default public boolean addChild(Collection parent, Collection child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), Arrays.asList(child));
    }

    default public boolean addChildren(Collection parent, List<Collection> children) {
        if (parent == null || children == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), children);
    }

    public boolean addChildren(UUID var1, List<Collection> var2);

    default public boolean addDigitalObject(Collection collection, DigitalObject digitalObject) {
        if (collection == null || digitalObject == null) {
            return false;
        }
        return this.addDigitalObjects(collection.getUuid(), Arrays.asList(digitalObject));
    }

    default public boolean addDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        if (collection == null || digitalObjects == null) {
            return false;
        }
        return this.addDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean addDigitalObjects(UUID var1, List<DigitalObject> var2);

    public Collection findOne(UUID var1, Filtering var2);

    @Override
    default public List<Collection> getChildren(Collection collection) {
        if (collection == null) {
            return null;
        }
        return this.getChildren(collection.getUuid());
    }

    default public PageResponse<DigitalObject> getDigitalObjects(Collection collection, PageRequest pageRequest) {
        if (collection == null) {
            return null;
        }
        return this.getDigitalObjects(collection.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID var1, PageRequest var2);

    public List<Collection> getParents(UUID var1);

    public PageResponse<Collection> getTopCollections(PageRequest var1);

    default public boolean removeChild(Collection parent, Collection child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.removeChild(parent.getUuid(), child.getUuid());
    }

    public boolean removeChild(UUID var1, UUID var2);

    default public boolean removeDigitalObject(Collection collection, DigitalObject digitalObject) {
        if (collection == null || digitalObject == null) {
            return false;
        }
        return this.removeDigitalObject(collection.getUuid(), digitalObject.getUuid());
    }

    public boolean removeDigitalObject(UUID var1, UUID var2);

    public boolean removeDigitalObjectFromAllCollections(DigitalObject var1);

    default public boolean saveDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) {
        if (collection == null || digitalObjects == null) {
            return false;
        }
        return this.saveDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean saveDigitalObjects(UUID var1, List<DigitalObject> var2);

    public Collection saveWithParentCollection(Collection var1, UUID var2);
}

