/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface NodeRepository<N extends Node>
extends IdentifiableRepository<N> {
    default public boolean addChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), Arrays.asList(child));
    }

    default public boolean addChildren(N parent, List<N> children) {
        if (parent == null || children == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), children);
    }

    public boolean addChildren(UUID var1, List<N> var2);

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID var1);

    default public List<N> getChildren(N node) {
        if (node == null) {
            return null;
        }
        return this.getChildren(node.getUuid());
    }

    public List<N> getChildren(UUID var1);

    public PageResponse<N> getChildren(UUID var1, PageRequest var2);

    public N getParent(UUID var1);

    public List<N> getParents(UUID var1);

    public PageResponse<N> getRootNodes(PageRequest var1);

    public List<Locale> getRootNodesLanguages();

    default public boolean removeChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.removeChild(parent.getUuid(), child.getUuid());
    }

    public boolean removeChild(UUID var1, UUID var2);

    public N saveWithParent(N var1, UUID var2);

    public boolean updateChildrenOrder(UUID var1, List<N> var2);
}

