/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public interface IdentifiableRepository<I extends Identifiable> {
    public long count();

    default public void delete(UUID uuid) {
        this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1);

    public boolean deleteIdentifiers(UUID var1);

    public PageResponse<I> find(PageRequest var1);

    public SearchPageResponse<I> find(SearchPageRequest var1);

    default public List<I> find(String searchTerm, int maxResults) {
        SearchPageRequestImpl request = new SearchPageRequestImpl(searchTerm, 0, maxResults, null);
        SearchPageResponse<I> response = this.find((SearchPageRequest)request);
        return response.getContent();
    }

    public List<I> findAllFull();

    public List<I> findAllReduced();

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public I findOne(Identifier var1);

    default public I findOne(UUID uuid) {
        return this.findOne(uuid, null);
    }

    public I findOne(UUID var1, Filtering var2);

    default public I findOneByIdentifier(String namespace, String id) {
        return this.findOne((Identifier)new IdentifierImpl(null, namespace, id));
    }

    default public I save(I identifiable) {
        return this.save(identifiable, null);
    }

    public I save(I var1, Map<String, Object> var2);

    default public I update(I identifiable) {
        return this.update(identifiable, null);
    }

    public I update(I var1, Map<String, Object> var2);
}

