/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public interface ProjectRepository
extends EntityRepository<Project> {
    default public boolean addDigitalObject(Project project, DigitalObject digitalObject) {
        if (project == null || digitalObject == null) {
            return false;
        }
        return this.addDigitalObjects(project.getUuid(), Arrays.asList(digitalObject));
    }

    default public boolean addDigitalObjects(Project project, List<DigitalObject> digitalObjects) {
        if (project == null || digitalObjects == null) {
            return false;
        }
        return this.addDigitalObjects(project.getUuid(), digitalObjects);
    }

    public boolean addDigitalObjects(UUID var1, List<DigitalObject> var2);

    default public PageResponse<DigitalObject> getDigitalObjects(Project project, PageRequest pageRequest) {
        if (project == null) {
            return null;
        }
        return this.getDigitalObjects(project.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID var1, PageRequest var2);

    default public boolean removeDigitalObject(Project project, DigitalObject digitalObject) {
        if (project == null || digitalObject == null) {
            return false;
        }
        return this.removeDigitalObject(project.getUuid(), digitalObject.getUuid());
    }

    public boolean removeDigitalObject(UUID var1, UUID var2);

    public boolean removeDigitalObjectFromAllProjects(UUID var1);

    default public boolean saveDigitalObjects(Project project, List<DigitalObject> digitalObjects) {
        if (project == null || digitalObjects == null) {
            return false;
        }
        return this.saveDigitalObjects(project.getUuid(), digitalObjects);
    }

    public boolean saveDigitalObjects(UUID var1, List<DigitalObject> var2);
}

