/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import java.util.List;
import java.util.UUID;

public interface EntityPartRepository<P extends EntityPart>
extends IdentifiableRepository<P> {
    default public void addRelatedEntity(P entityPart, Entity entity) {
        if (entityPart == null || entity == null) {
            return;
        }
        this.addRelatedEntity(entityPart.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2);

    default public void addRelatedFileresource(P entityPart, FileResource fileResource) {
        if (entityPart == null || fileResource == null) {
            return;
        }
        this.addRelatedFileresource(entityPart.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2);

    default public List<Entity> getRelatedEntities(P entityPart) {
        if (entityPart == null) {
            return null;
        }
        return this.getRelatedEntities(entityPart.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1);

    default public List<FileResource> getRelatedFileResources(P entityPart) {
        if (entityPart == null) {
            return null;
        }
        return this.getRelatedFileResources(entityPart.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1);

    default public List<Entity> saveRelatedEntities(P entityPart, List<Entity> entities) {
        if (entityPart == null || entities == null) {
            return null;
        }
        return this.saveRelatedEntities(entityPart.getUuid(), entities);
    }

    public List<Entity> saveRelatedEntities(UUID var1, List<Entity> var2);

    default public List<FileResource> saveRelatedFileResources(P entityPart, List<FileResource> fileResources) {
        if (entityPart == null || fileResources == null) {
            return null;
        }
        return this.saveRelatedFileResources(entityPart.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID var1, List<FileResource> var2);
}

