/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.impl.identifiable.resource.ApplicationFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.AudioFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.TextFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.VideoFileResourceImpl;
import java.util.UUID;

public interface FileResourceMetadataRepository<F extends FileResource>
extends IdentifiableRepository<F> {
    default public FileResource createByMimeType(MimeType mimeType) {
        AudioFileResourceImpl result;
        String primaryType;
        if (mimeType == null) {
            return new ApplicationFileResourceImpl();
        }
        switch (primaryType = mimeType.getPrimaryType()) {
            case "audio": {
                result = new AudioFileResourceImpl();
                break;
            }
            case "image": {
                result = new ImageFileResourceImpl();
                break;
            }
            case "text": {
                result = new TextFileResourceImpl();
                break;
            }
            case "video": {
                result = new VideoFileResourceImpl();
                break;
            }
            default: {
                result = new ApplicationFileResourceImpl();
            }
        }
        result.setMimeType(mimeType);
        UUID uuid = UUID.randomUUID();
        result.setUuid(uuid);
        return result;
    }
}

