/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public interface IdentifiableRepository<I extends Identifiable> {
    default public void addRelatedEntity(I identifiable, Entity entity) {
        if (identifiable == null || entity == null) {
            return;
        }
        this.addRelatedEntity(identifiable.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2);

    default public void addRelatedFileresource(I identifiable, FileResource fileResource) {
        if (identifiable == null || fileResource == null) {
            return;
        }
        this.addRelatedFileresource(identifiable.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2);

    public long count();

    default public void delete(UUID uuid) {
        this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1);

    public PageResponse<I> find(PageRequest var1);

    public SearchPageResponse<I> find(SearchPageRequest var1);

    default public List<I> find(String searchTerm, int maxResults) {
        SearchPageRequest request = new SearchPageRequest(searchTerm, 0, maxResults, null);
        SearchPageResponse<I> response = this.find(request);
        return response.getContent();
    }

    public List<I> findAllFull();

    public List<I> findAllReduced();

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public I findOne(Identifier var1);

    default public I findOne(UUID uuid) {
        return this.findOne(uuid, null);
    }

    public I findOne(UUID var1, Filtering var2);

    default public I findOneByIdentifier(String namespace, String id) {
        return this.findOne(new Identifier(null, namespace, id));
    }

    public List<Locale> getLanguages();

    default public List<Entity> getRelatedEntities(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedEntities(identifiable.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1);

    default public List<FileResource> getRelatedFileResources(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedFileResources(identifiable.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1);

    default public I save(I identifiable) {
        return this.save(identifiable, null);
    }

    public I save(I var1, Map<String, Object> var2);

    default public List<Entity> saveRelatedEntities(I identifiable, List<Entity> entities) {
        if (identifiable == null || entities == null) {
            return null;
        }
        return this.saveRelatedEntities(identifiable.getUuid(), entities);
    }

    public List<Entity> saveRelatedEntities(UUID var1, List<Entity> var2);

    default public List<FileResource> saveRelatedFileResources(I identifiable, List<FileResource> fileResources) {
        if (identifiable == null || fileResources == null) {
            return null;
        }
        return this.saveRelatedFileResources(identifiable.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID var1, List<FileResource> var2);

    default public I update(I identifiable) {
        return this.update(identifiable, null);
    }

    public I update(I var1, Map<String, Object> var2);
}

