/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public interface IdentifiableRepository<I extends Identifiable> {
    default public void addRelatedEntity(I identifiable, Entity entity) {
        if (identifiable == null || entity == null) {
            return;
        }
        this.addRelatedEntity(identifiable.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2);

    default public void addRelatedFileresource(I identifiable, FileResource fileResource) {
        if (identifiable == null || fileResource == null) {
            return;
        }
        this.addRelatedFileresource(identifiable.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2);

    public long count();

    default public void delete(UUID uuid) {
        this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1);

    public PageResponse<I> find(PageRequest var1);

    default public List<I> find(String searchTerm, int maxResults) {
        PageRequest request = new PageRequest(searchTerm, 0, maxResults, null);
        PageResponse<I> response = this.find(request);
        return response.getContent();
    }

    public List<I> getAllFull();

    public List<I> getAllReduced();

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public I getByIdentifier(Identifier var1);

    default public I getByUuid(UUID uuid) {
        return this.getByUuidAndFiltering(uuid, null);
    }

    public I getByUuidAndFiltering(UUID var1, Filtering var2);

    default public I getByIdentifier(String namespace, String id) {
        return this.getByIdentifier(new Identifier(null, namespace, id));
    }

    public List<Locale> getLanguages();

    default public List<Entity> getRelatedEntities(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedEntities(identifiable.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1);

    default public List<FileResource> getRelatedFileResources(I identifiable) {
        if (identifiable == null) {
            return null;
        }
        return this.getRelatedFileResources(identifiable.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1);

    default public I save(I identifiable) {
        return this.save(identifiable, null);
    }

    public I save(I var1, Map<String, Object> var2);

    default public List<Entity> setRelatedEntities(I identifiable, List<Entity> entities) {
        if (identifiable == null || entities == null) {
            return null;
        }
        return this.setRelatedEntities(identifiable.getUuid(), entities);
    }

    public List<Entity> setRelatedEntities(UUID var1, List<Entity> var2);

    default public List<FileResource> setRelatedFileResources(I identifiable, List<FileResource> fileResources) {
        if (identifiable == null || fileResources == null) {
            return null;
        }
        return this.setRelatedFileResources(identifiable.getUuid(), fileResources);
    }

    public List<FileResource> setRelatedFileResources(UUID var1, List<FileResource> var2);

    default public I update(I identifiable) {
        return this.update(identifiable, null);
    }

    public I update(I var1, Map<String, Object> var2);
}

