/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.semantic;

import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.semantic.Headword;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface HeadwordRepository {
    public void addRelatedEntity(UUID var1, UUID var2);

    public void addRelatedFileresource(UUID var1, UUID var2);

    public long count();

    public void delete(String var1, Locale var2);

    public void delete(UUID var1);

    public boolean delete(List<UUID> var1);

    public void deleteRelatedEntities(UUID var1);

    public void deleteRelatedFileresources(UUID var1);

    public PageResponse<Headword> find(PageRequest var1);

    default public List<Headword> find(String searchTerm, int maxResults) {
        PageRequest request = new PageRequest(searchTerm, 0, maxResults, null);
        PageResponse<Headword> response = this.find(request);
        return response.getContent();
    }

    public List<Headword> find(String var1, Locale var2);

    public List<Headword> getAll();

    public List<Headword> findByLabel(String var1);

    public PageResponse<Headword> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public List<Headword> getRandom(int var1);

    public Headword findByLabelAndLocale(String var1, Locale var2);

    default public Headword getByUuid(UUID uuid) {
        return this.findByUuidAndFiltering(uuid, null);
    }

    public Headword findByUuidAndFiltering(UUID var1, Filtering var2);

    public List<Locale> getLanguages();

    public List<Entity> getRelatedEntities(UUID var1);

    public PageResponse<Entity> findRelatedEntities(UUID var1, PageRequest var2);

    public List<FileResource> getRelatedFileResources(UUID var1);

    public PageResponse<FileResource> findRelatedFileResources(UUID var1, PageRequest var2);

    public Headword save(Headword var1);

    public List<Entity> setRelatedEntities(UUID var1, List<Entity> var2);

    public List<FileResource> setRelatedFileResources(UUID var1, List<FileResource> var2);

    public Headword update(Headword var1);
}

