/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public interface IdentifierRepository
extends UniqueObjectRepository<Identifier> {
    default public int deleteByIdentifiable(Identifiable identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        return this.deleteByIdentifiable(identifiable.getUuid());
    }

    public int deleteByIdentifiable(UUID var1) throws RepositoryException;

    default public List<Identifier> findByIdentifiable(Identifiable identifiable) throws RepositoryException {
        if (identifiable == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findByIdentifiable(identifiable.getUuid());
    }

    public List<Identifier> findByIdentifiable(UUID var1) throws RepositoryException;

    default public Identifier getByIdentifier(Identifier identifier) throws RepositoryException {
        if (identifier == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return (Identifier)this.getByUuid(identifier.getUuid());
    }

    @Override
    default public void save(Identifier uniqueObject) throws RepositoryException {
        throw new UnsupportedOperationException("saving without related Identifiable not supported - use saveForIdentifiable instead.");
    }

    public Set<Identifier> saveForIdentifiable(Identifiable var1, Set<Identifier> var2) throws RepositoryException;
}

