/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.TextFileResource;
import de.digitalcollections.model.identifiable.resource.VideoFileResource;
import java.util.UUID;

public interface FileResourceMetadataRepository<F extends FileResource>
extends IdentifiableRepository<F> {
    default public FileResource createByMimeType(MimeType mimeType) {
        String primaryType;
        if (mimeType == null) {
            return new ApplicationFileResource();
        }
        AudioFileResource result = switch (primaryType = mimeType.getPrimaryType()) {
            case "audio" -> new AudioFileResource();
            case "image" -> new ImageFileResource();
            case "text" -> new TextFileResource();
            case "video" -> new VideoFileResource();
            default -> new ApplicationFileResource();
        };
        result.setMimeType(mimeType);
        UUID uuid = UUID.randomUUID();
        result.setUuid(uuid);
        return result;
    }
}

