/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository;

import de.digitalcollections.cudami.server.backend.api.repository.PagingSortingFilteringRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.filtering.Filtering;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public interface UniqueObjectRepository<U extends UniqueObject>
extends PagingSortingFilteringRepository<U> {
    public long count() throws RepositoryException;

    public U create() throws RepositoryException;

    default public int delete(Set<U> uniqueObjects) throws RepositoryException {
        if (uniqueObjects == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        if (uniqueObjects.isEmpty()) {
            return 0;
        }
        List<UUID> list = uniqueObjects.stream().map(i -> i.getUuid()).collect(Collectors.toList());
        return this.deleteByUuids(list);
    }

    default public boolean delete(U uniqueObject) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("delete failed: given object must not be null");
        }
        return this.deleteByUuid(uniqueObject.getUuid());
    }

    public boolean deleteByUuid(UUID var1) throws RepositoryException;

    public int deleteByUuids(List<UUID> var1) throws RepositoryException;

    default public U getByExample(U uniqueObject) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getByUuid(uniqueObject.getUuid());
    }

    default public U getByExampleAndFiltering(U uniqueObject, Filtering filtering) throws RepositoryException {
        if (uniqueObject == null || filtering == null) {
            throw new IllegalArgumentException("get failed: given objects must not be null");
        }
        return this.getByUuidAndFiltering(uniqueObject.getUuid(), filtering);
    }

    default public U getByUuid(UUID uniqueObjectUuid) throws RepositoryException {
        return this.getByUuidAndFiltering(uniqueObjectUuid, null);
    }

    public U getByUuidAndFiltering(UUID var1, Filtering var2) throws RepositoryException;

    public List<U> getRandom(int var1) throws RepositoryException;

    default public void save(U uniqueObject) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("save failed: given object must not be null");
        }
        this.save(uniqueObject, null);
    }

    public void save(U var1, Map<String, Object> var2) throws RepositoryException;

    default public void saveOrUpdate(U uniqueObject) throws RepositoryException {
        UUID uuid = uniqueObject.getUuid();
        if (uuid != null) {
            this.update(uniqueObject);
        } else {
            this.save(uniqueObject);
        }
    }

    default public void update(U uniqueObject) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("update failed: given object must not be null");
        }
        this.update(uniqueObject, null);
    }

    public void update(U var1, Map<String, Object> var2) throws RepositoryException;
}

