/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Set;
import java.util.UUID;

public interface WorkRepository
extends EntityRepository<Work> {
    public PageResponse<Work> findByPerson(UUID var1) throws RepositoryException;

    default public PageResponse<Work> findEmbeddedWorks(Work work, PageRequest pageRequest) throws RepositoryException {
        if (work == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findEmbeddedWorks(work.getUuid(), pageRequest);
    }

    public PageResponse<Work> findEmbeddedWorks(UUID var1, PageRequest var2) throws RepositoryException;

    default public Work getByItem(Item item) throws RepositoryException {
        if (item == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getByItem(item.getUuid());
    }

    public Work getByItem(UUID var1) throws RepositoryException;

    default public Set<Work> getByPerson(Person person) throws RepositoryException {
        if (person == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getByPerson(person.getUuid());
    }

    public Set<Work> getByPerson(UUID var1) throws RepositoryException;
}

