/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.semantic;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.buckets.BucketObjectsRequest;
import de.digitalcollections.model.list.buckets.BucketObjectsResponse;
import de.digitalcollections.model.list.buckets.BucketsRequest;
import de.digitalcollections.model.list.buckets.BucketsResponse;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.semantic.Headword;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface HeadwordRepository
extends UniqueObjectRepository<Headword> {
    default public void addRelatedEntity(Headword headword, Entity entity) throws RepositoryException {
        if (headword == null || entity == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        this.addRelatedEntity(headword.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID var1, UUID var2) throws RepositoryException;

    default public void addRelatedFileresource(Headword headword, FileResource fileResource) throws RepositoryException {
        if (headword == null || fileResource == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        this.addRelatedFileresource(headword.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID var1, UUID var2) throws RepositoryException;

    public void deleteByLabelAndLocale(String var1, Locale var2) throws RepositoryException;

    public void deleteRelatedEntities(UUID var1) throws RepositoryException;

    public void deleteRelatedFileresources(UUID var1) throws RepositoryException;

    public BucketObjectsResponse<Headword> find(BucketObjectsRequest<Headword> var1) throws RepositoryException;

    public BucketsResponse<Headword> find(BucketsRequest<Headword> var1) throws RepositoryException;

    public List<Headword> find(String var1, Locale var2) throws RepositoryException;

    public List<Headword> findByLabel(String var1) throws RepositoryException;

    public PageResponse<Headword> findByLanguageAndInitial(PageRequest var1, String var2, String var3) throws RepositoryException;

    default public PageResponse<Entity> findRelatedEntities(Headword headword, PageRequest pageRequest) throws RepositoryException {
        if (headword == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findRelatedEntities(headword.getUuid(), pageRequest);
    }

    public PageResponse<Entity> findRelatedEntities(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<FileResource> findRelatedFileResources(Headword headword, PageRequest pageRequest) throws RepositoryException {
        if (headword == null) {
            throw new IllegalArgumentException("find failed: given object must not be null");
        }
        return this.findRelatedFileResources(headword.getUuid(), pageRequest);
    }

    public PageResponse<FileResource> findRelatedFileResources(UUID var1, PageRequest var2) throws RepositoryException;

    public Headword getByLabelAndLocale(String var1, Locale var2) throws RepositoryException;

    public List<Locale> getLanguages() throws RepositoryException;

    default public List<Entity> getRelatedEntities(Headword headword) throws RepositoryException {
        if (headword == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getRelatedEntities(headword.getUuid());
    }

    public List<Entity> getRelatedEntities(UUID var1) throws RepositoryException;

    default public List<FileResource> getRelatedFileResources(Headword headword) throws RepositoryException {
        if (headword == null) {
            throw new IllegalArgumentException("get failed: given object must not be null");
        }
        return this.getRelatedFileResources(headword.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID var1) throws RepositoryException;

    default public List<Entity> setRelatedEntities(Headword headword, List<Entity> entities) throws RepositoryException {
        if (headword == null || entities == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setRelatedEntities(headword.getUuid(), entities);
    }

    public List<Entity> setRelatedEntities(UUID var1, List<Entity> var2) throws RepositoryException;

    default public List<FileResource> setRelatedFileResources(Headword headword, List<FileResource> fileResources) throws RepositoryException {
        if (headword == null || fileResources == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setRelatedFileResources(headword.getUuid(), fileResources);
    }

    public List<FileResource> setRelatedFileResources(UUID var1, List<FileResource> var2) throws RepositoryException;
}

