/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.relation;

import de.digitalcollections.cudami.server.backend.api.repository.PagingSortingFilteringRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.UUID;

public interface EntityToEntityRelationRepository
extends PagingSortingFilteringRepository<EntityRelation> {
    default public void addRelation(EntityRelation relation) throws RepositoryException {
        this.addRelation(relation.getSubject().getUuid(), relation.getPredicate(), relation.getObject().getUuid());
    }

    public void addRelation(UUID var1, String var2, UUID var3) throws RepositoryException;

    default public void deleteByObject(Entity objectEntity) throws RepositoryException {
        if (objectEntity == null) {
            throw new IllegalArgumentException("object entity must not be null");
        }
        this.deleteByObject(objectEntity.getUuid());
    }

    public void deleteByObject(UUID var1) throws RepositoryException;

    default public void deleteBySubject(Entity subjectEntity) throws RepositoryException {
        this.deleteBySubject(subjectEntity.getUuid());
    }

    public void deleteBySubject(UUID var1) throws RepositoryException;

    default public PageResponse<EntityRelation> findBySubject(Entity subjectEntity, PageRequest pageRequest) throws RepositoryException {
        if (subjectEntity == null) {
            throw new IllegalArgumentException("subject entity must not be null");
        }
        return this.findBySubject(subjectEntity.getUuid(), pageRequest);
    }

    public PageResponse<EntityRelation> findBySubject(UUID var1, PageRequest var2) throws RepositoryException;

    default public void save(EntityRelation relation) throws RepositoryException {
        this.save(List.of(relation));
    }

    public void save(List<EntityRelation> var1) throws RepositoryException;

    public void save(UUID var1, String var2, UUID var3) throws RepositoryException;
}

