/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public interface CollectionRepository
extends NodeRepository<Collection>,
EntityRepository<Collection> {
    default public boolean addDigitalObject(Collection collection, DigitalObject digitalObject) throws RepositoryException {
        if (collection == null || digitalObject == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        return this.addDigitalObjects(collection.getUuid(), Arrays.asList(digitalObject));
    }

    default public boolean addDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) throws RepositoryException {
        if (collection == null || digitalObjects == null) {
            throw new IllegalArgumentException("add failed: given objects must not be null");
        }
        return this.addDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean addDigitalObjects(UUID var1, List<DigitalObject> var2) throws RepositoryException;

    default public PageResponse<DigitalObject> findDigitalObjects(Collection collection, PageRequest pageRequest) throws RepositoryException {
        if (collection == null) {
            throw new IllegalArgumentException("find failed: given collection must not be null");
        }
        return this.findDigitalObjects(collection.getUuid(), pageRequest);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID var1, PageRequest var2) throws RepositoryException;

    default public boolean removeDigitalObject(Collection collection, DigitalObject digitalObject) throws RepositoryException {
        if (collection == null || digitalObject == null) {
            throw new IllegalArgumentException("remove failed: given objects must not be null");
        }
        return this.removeDigitalObject(collection.getUuid(), digitalObject.getUuid());
    }

    public boolean removeDigitalObject(UUID var1, UUID var2) throws RepositoryException;

    default public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) throws RepositoryException {
        if (digitalObject == null) {
            throw new IllegalArgumentException("remove failed: given object must not be null");
        }
        return this.removeDigitalObjectFromAllCollections(digitalObject.getUuid());
    }

    public boolean removeDigitalObjectFromAllCollections(UUID var1) throws RepositoryException;

    default public boolean setDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) throws RepositoryException {
        if (collection == null || digitalObjects == null) {
            throw new IllegalArgumentException("set failed: given objects must not be null");
        }
        return this.setDigitalObjects(collection.getUuid(), digitalObjects);
    }

    public boolean setDigitalObjects(UUID var1, List<DigitalObject> var2) throws RepositoryException;
}

