/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.UUID;

public interface WebsiteRepository
extends EntityRepository<Website> {
    public PageResponse<Webpage> findRootWebpages(UUID var1, PageRequest var2) throws RepositoryException;

    default public PageResponse<Webpage> findRootWebpages(Website website, PageRequest pageRequest) throws RepositoryException {
        if (website == null) {
            throw new IllegalArgumentException("find failed: given website must not be null");
        }
        return this.findRootWebpages(website.getUuid(), pageRequest);
    }

    public List<Webpage> getRootWebpages(UUID var1) throws RepositoryException;

    default public List<Webpage> getRootWebpages(Website website) throws RepositoryException {
        if (website == null) {
            throw new IllegalArgumentException("get failed: given website must not be null");
        }
        return this.getRootWebpages(website.getUuid());
    }

    public boolean updateRootWebpagesOrder(UUID var1, List<Webpage> var2) throws RepositoryException;

    default public boolean updateRootWebpagesOrder(Website website, List<Webpage> rootPages) throws RepositoryException {
        if (website == null || rootPages == null) {
            throw new IllegalArgumentException("update failed: given objects must not be null");
        }
        return this.updateRootWebpagesOrder(website.getUuid(), rootPages);
    }
}

