/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.cudami.model.api.identifiable.entity.Entity;
import de.digitalcollections.cudami.model.api.identifiable.entity.EntityType;
import de.digitalcollections.cudami.model.api.identifiable.resource.ContentNode;
import de.digitalcollections.cudami.model.impl.identifiable.entity.ContentTreeImpl;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ContentTreeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentTreeRepositoryImpl
extends AbstractPagingAndSortingRepositoryImpl
implements ContentTreeRepository<ContentTree> {
    @Autowired
    private Jdbi dbi;
    @Autowired
    private EntityRepository entityRepository;
    private static final String ENTITY_WHERE_CLAUSE = " entities.entity_type='" + EntityType.CONTENT_TREE + "'";

    public long count() {
        String sql = "SELECT count(*) FROM entities WHERE" + ENTITY_WHERE_CLAUSE;
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public ContentTree create() {
        return new ContentTreeImpl();
    }

    public PageResponse<ContentTree> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT * FROM entities INNER JOIN identifiables ON entities.uuid=identifiables.uuid WHERE" + ENTITY_WHERE_CLAUSE);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ContentTreeImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public ContentTree findOne(UUID uuid) {
        String query = "SELECT * FROM entities INNER JOIN identifiables ON entities.uuid=identifiables.uuid WHERE" + ENTITY_WHERE_CLAUSE + " AND uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(ContentTreeImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (ContentTree)list.get(0);
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return null;
    }

    public List<ContentNode> getRootNodes(ContentTree contentTree) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ContentTree save(ContentTree contentTree) {
        Entity entity = (Entity)this.entityRepository.save((Identifiable)contentTree);
        this.saveRootNodes(contentTree);
        ContentTree result = this.findOne(entity.getUuid());
        return result;
    }

    private void saveRootNodes(ContentTree contentTree) {
        List rootNodes = contentTree.getRootNodes();
        if (rootNodes == null || !rootNodes.isEmpty()) {
            // empty if block
        }
    }

    public ContentTree update(ContentTree contentTree) {
        ContentTree result = (ContentTree)this.entityRepository.update((Identifiable)contentTree);
        this.saveRootNodes(contentTree);
        return result;
    }
}

