/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.Website;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.cudami.model.impl.identifiable.resource.WebpageImpl;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl
extends AbstractPagingAndSortingRepositoryImpl
implements WebsiteRepository<Website> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteRepositoryImpl.class);
    @Autowired
    private Jdbi dbi;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private EntityRepository entityRepository;

    public long count() {
        String sql = "SELECT count(*) FROM websites";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public Website create() {
        return new WebsiteImpl();
    }

    public PageResponse<Website> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT ws.id as id, ws.uuid as uuid, ws.url as url, ws.registration_date as registration_date, i.label as label, i.description as description").append(" FROM websites ws INNER JOIN entities e ON ws.uuid=e.uuid INNER JOIN identifiables i ON ws.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(WebsiteImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public Website findOne(UUID uuid) {
        String query = "SELECT ws.uuid as uuid, ws.url as url, ws.registration_date as registration_date, i.label as label, i.description as description FROM websites ws INNER JOIN entities e ON ws.uuid=e.uuid INNER JOIN identifiables i ON ws.uuid=i.uuid WHERE ws.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebsiteImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        WebsiteImpl website = (WebsiteImpl)list.get(0);
        website.setRootPages(this.getRootPages((Website)website));
        return website;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"url"};
    }

    public List<Webpage> getRootPages(Website website) {
        String query = "SELECT ww.webpage_uuid as uuid, i.label as label FROM websites ws INNER JOIN website_webpage ww ON ws.uuid=ww.website_uuid INNER JOIN identifiables i ON ww.webpage_uuid=i.uuid WHERE ws.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)website.getUuid())).mapToBean(WebpageImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<Webpage>();
        }
        return list.stream().map(Webpage.class::cast).collect(Collectors.toList());
    }

    public Website save(Website website) {
        this.entityRepository.save((Identifiable)website);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO websites(url, registration_date, uuid) VALUES (:url, :registrationDate, :uuid)").bindBean((Object)website)).execute());
        return this.findOne(website.getUuid());
    }

    public Website update(Website website) {
        this.entityRepository.update((Identifiable)website);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE websites SET url=:url, registration_date=:registrationDate WHERE uuid=:uuid").bindBean((Object)website)).execute());
        return this.findOne(website.getUuid());
    }
}

