/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.impl.identifiable.resource.ResourceImpl;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.ResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ResourceRepositoryImpl<R extends ResourceImpl>
extends AbstractPagingAndSortingRepositoryImpl
implements ResourceRepository<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRepositoryImpl.class);
    @Autowired
    private Jdbi dbi;
    @Autowired
    private IdentifiableRepositoryImpl identifiableRepository;

    public long count() {
        String sql = "SELECT count(*) FROM resources";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public R create() {
        return (R)new ResourceImpl();
    }

    public PageResponse<R> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT r.resource_type as resourceType, r.uuid as uuid, i.label as label, i.description as description").append(" FROM resources r INNER JOIN identifiables i ON r.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ResourceImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public R findOne(UUID uuid) {
        String query = "SELECT r.resource_type as resourceType, r.uuid as uuid, i.label as label, i.description as description FROM resources r INNER JOIN identifiables i ON r.uuid=i.uuid WHERE r.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(ResourceImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (R)((ResourceImpl)list.get(0));
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "resourceType", "lastModified"};
    }

    public R save(R resource) {
        this.identifiableRepository.save(resource);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO resources(resource_type, uuid) VALUES (:resourceType, :uuid)").bindBean(resource)).execute());
        return this.findOne(resource.getUuid());
    }

    public R update(R resource) {
        this.identifiableRepository.update(resource);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE resources SET resource_type=:resourceType WHERE uuid=:uuid").bindBean(resource)).execute());
        return this.findOne(resource.getUuid());
    }
}

