/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.parts.MultilanguageDocument;
import de.digitalcollections.cudami.model.api.identifiable.parts.Text;
import de.digitalcollections.cudami.model.api.identifiable.resource.Webpage;
import de.digitalcollections.cudami.model.impl.identifiable.parts.MultilanguageDocumentImpl;
import de.digitalcollections.cudami.model.impl.identifiable.parts.TextImpl;
import de.digitalcollections.cudami.model.impl.identifiable.resource.WebpageImpl;
import de.digitalcollections.cudami.server.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.ResourceRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import de.digitalcollections.prosemirror.model.api.ContentBlock;
import de.digitalcollections.prosemirror.model.api.Document;
import de.digitalcollections.prosemirror.model.impl.DocumentImpl;
import de.digitalcollections.prosemirror.model.impl.contentblocks.ParagraphImpl;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl
extends AbstractPagingAndSortingRepositoryImpl
implements WebpageRepository<Webpage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);
    @Autowired
    private Jdbi dbi;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    LocaleRepository localeRepository;

    public long count() {
        String sql = "SELECT count(*) FROM webpages";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public Webpage create() {
        Locale defaultLocale = this.localeRepository.getDefault();
        WebpageImpl webpage = new WebpageImpl();
        webpage.setLabel((Text)new TextImpl(defaultLocale, ""));
        webpage.setDescription(this.createEmptyMLD(defaultLocale));
        webpage.setText(this.createEmptyMLD(defaultLocale));
        return webpage;
    }

    private MultilanguageDocument createEmptyMLD(Locale defaultLocale) {
        MultilanguageDocumentImpl emptyMLD = new MultilanguageDocumentImpl();
        DocumentImpl document = new DocumentImpl();
        document.addContentBlock((ContentBlock)new ParagraphImpl());
        emptyMLD.addDocument(defaultLocale, (Document)document);
        return emptyMLD;
    }

    public PageResponse<Webpage> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT wp.uuid as uuid, wp.text as text, i.label as label, i.description as description").append(" FROM webpages wp INNER JOIN resources r ON wp.uuid=r.uuid INNER JOIN identifiables i ON wp.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(WebpageImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public Webpage findOne(UUID uuid) {
        String query = "SELECT wp.uuid as uuid, wp.text as text, i.label as label, i.description as description FROM webpages wp INNER JOIN resources r ON wp.uuid=r.uuid INNER JOIN identifiables i ON wp.uuid=i.uuid WHERE wp.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (Webpage)list.get(0);
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    public Webpage save(Webpage webpage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Webpage save(Webpage webpage, UUID websiteUuid) {
        this.resourceRepository.save((Identifiable)webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO webpages(uuid, text) VALUES (:uuid, :text::JSONB)").bindBean((Object)webpage)).execute());
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO website_webpage(website_uuid, webpage_uuid) VALUES (:website_uuid, :uuid)").bind("website_uuid", (Object)websiteUuid)).bindBean((Object)webpage)).execute());
        return this.findOne(webpage.getUuid());
    }

    public Webpage update(Webpage webpage) {
        this.resourceRepository.update((Identifiable)webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE webpages SET text=:text::JSONB WHERE uuid=:uuid").bindBean((Object)webpage)).execute());
        return this.findOne(webpage.getUuid());
    }
}

