/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.security;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.api.security.enums.Role;
import de.digitalcollections.cudami.model.impl.security.UserImpl;
import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
extends AbstractPagingAndSortingRepositoryImpl
implements UserRepository<UserImpl> {
    @Autowired
    private Jdbi dbi;

    public long count() {
        String sql = "SELECT count(*) FROM users";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public UserImpl create() {
        return new UserImpl();
    }

    public PageResponse<UserImpl> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT * FROM users");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(UserImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public List<UserImpl> findActiveAdminUsers() {
        return (List)this.dbi.withHandle(h -> h.createQuery("SELECT * FROM users WHERE '" + Role.ADMIN.name() + "' = any(roles)").mapToBean(UserImpl.class).list());
    }

    public UserImpl findByEmail(String email) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM users WHERE email = :email").bind("email", email)).mapToBean(UserImpl.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (UserImpl)users.get(0);
    }

    public UserImpl findOne(UUID uuid) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM users WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToBean(UserImpl.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (UserImpl)users.get(0);
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"email", "lastname", "firstname"};
    }

    public UserImpl save(UserImpl user) {
        user.setUuid(UUID.randomUUID());
        UserImpl result = (UserImpl)this.dbi.withHandle(h -> (UserImpl)((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("INSERT INTO users(email, enabled, firstname, lastname, passwordHash, roles, uuid) VALUES (:email, :enabled, :firstname, :lastname, :passwordHash, :roles, :uuid) RETURNING *").bindBean((Object)user)).mapToBean(UserImpl.class).findOnly());
        return result;
    }

    public UserImpl update(UserImpl user) {
        UserImpl result = (UserImpl)this.dbi.withHandle(h -> (UserImpl)((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("UPDATE users SET email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, passwordHash=:passwordHash, roles=:roles, uuid=:uuid WHERE uuid=:uuid RETURNING *").bindBean((Object)user)).mapToBean(UserImpl.class).findOnly());
        return result;
    }
}

