/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.core.model.impl.paging.PageResponseImpl;
import de.digitalcollections.cudami.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifiableRepositoryImpl<I extends IdentifiableImpl>
extends AbstractPagingAndSortingRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    @Autowired
    private Jdbi dbi;
    @Autowired
    ObjectMapper objectMapper;

    public long count() {
        String sql = "SELECT count(*) FROM identifiables";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    public I create() {
        return (I)new IdentifiableImpl();
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT * FROM identifiables");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(IdentifiableImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public I findOne(UUID uuid) {
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM identifiables WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToBean(IdentifiableImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (I)((IdentifiableImpl)list.get(0));
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "type", "lastModified"};
    }

    public I save(I identifiable) {
        identifiable.setUuid(UUID.randomUUID());
        identifiable.setCreated(LocalDateTime.now());
        identifiable.setLastModified(LocalDateTime.now());
        IdentifiableImpl result = null;
        result = (IdentifiableImpl)this.dbi.withHandle(h -> (IdentifiableImpl)((Query)h.createQuery("INSERT INTO identifiables(created, description, identifiable_type, label, last_modified, iiif_image, uuid) VALUES (:created, :description::JSONB, :type, :label::JSONB, :lastModified, :iiifImage::JSONB, :uuid) RETURNING *").bindBean(identifiable)).mapToBean(IdentifiableImpl.class).findOnly());
        return (I)result;
    }

    public I update(I identifiable) {
        identifiable.setLastModified(LocalDateTime.now());
        IdentifiableImpl result = null;
        result = (IdentifiableImpl)this.dbi.withHandle(h -> (IdentifiableImpl)((Query)h.createQuery("UPDATE identifiables SET description=:description::JSONB, identifiable_type=:type, label=:label::JSONB, last_modified=:lastModified, iiif_image=:iiifImage::JSONB WHERE uuid=:uuid RETURNING *").bindBean(identifiable)).mapToBean(IdentifiableImpl.class).findOnly());
        return (I)result;
    }
}

