/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.identifiable.parts.Translation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.identifiable.entity.ArticleImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl<A extends Article, I extends Identifiable>
extends EntityRepositoryImpl<A>
implements ArticleRepository<A, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticleRepositoryImpl.class);
    private final EntityRepository entityRepository;
    private final LocaleRepository localeRepository;

    @Autowired
    public ArticleRepositoryImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository, @Qualifier(value="entityRepositoryImpl") EntityRepository entityRepository, LocaleRepository localeRepository, Jdbi dbi) {
        super(dbi, identifiableRepository);
        this.entityRepository = entityRepository;
        this.localeRepository = localeRepository;
    }

    public void addIdentifiable(UUID articleUuid, UUID identifiableUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "article_identifiables", "article_uuid", articleUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO article_identifiables(article_uuid, identifiable_uuid, sortIndex) VALUES (:article_uuid, :identifiable_uuid, :sortIndex)").bind("article_uuid", (Object)articleUuid)).bind("identifiable_uuid", (Object)identifiableUuid)).bind("sortIndex", sortIndex)).execute());
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM articles";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<A> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT a.uuid as uuid, a.text as text, i.label as label, i.description as description").append(" FROM articles a INNER JOIN entities e ON a.uuid=e.uuid INNER JOIN identifiables i ON a.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ArticleImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public A findOne(UUID uuid) {
        String query = "SELECT a.uuid as uuid, a.text as text, i.label as label, i.description as description FROM articles a INNER JOIN entities e ON a.uuid=e.uuid INNER JOIN identifiables i ON a.uuid=i.uuid WHERE a.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(ArticleImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        Article article = (Article)list.get(0);
        article.setIdentifiables(this.getIdentifiables(article));
        return (A)article;
    }

    public A findOne(UUID uuid, Locale locale) {
        Locale fLocale;
        A article = this.findOne(uuid);
        Set translations = article.getLabel().getTranslations();
        if (locale == null) {
            Optional translation2 = translations.stream().findFirst();
            locale = translation2.map(Translation::getLocale).orElse(null);
        }
        if ((fLocale = locale) == null) {
            return null;
        }
        boolean requestedTranslationExists = translations.stream().anyMatch(translation -> translation.getLocale().equals(fLocale));
        if (!requestedTranslationExists) {
            return null;
        }
        article.getLabel().getTranslations().removeIf(translation -> !translation.getLocale().equals(fLocale));
        if (article.getDescription() != null && article.getDescription().getLocalizedStructuredContent() != null) {
            article.getDescription().getLocalizedStructuredContent().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        if (article.getText() != null && article.getText().getLocalizedStructuredContent() != null) {
            article.getText().getLocalizedStructuredContent().entrySet().removeIf(entry -> !entry.getKey().equals(fLocale));
        }
        return article;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    @Override
    public A save(A article) {
        this.entityRepository.save(article);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO articles(uuid, text) VALUES (:uuid, :text::JSONB)").bindBean(article)).execute());
        return this.findOne(article.getUuid());
    }

    @Override
    public A update(A article) {
        this.entityRepository.update(article);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE articles SET text=:text::JSONB WHERE uuid=:uuid").bindBean(article)).execute());
        return this.findOne(article.getUuid());
    }

    public List<Identifiable> getIdentifiables(A article) {
        return this.getIdentifiables(article.getUuid());
    }

    public List<Identifiable> getIdentifiables(UUID identifiableUuid) {
        String query = "SELECT i.uuid as uuid, i.label as label FROM identifiables i INNER JOIN article_identifiables ai ON ai.identifiable_uuid=i.uuid WHERE ai.article_uuid = :uuid ORDER BY ai.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)identifiableUuid)).mapToBean(IdentifiableImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<Identifiable>();
        }
        return list.stream().map(Identifiable.class::cast).collect(Collectors.toList());
    }

    public List<Identifiable> saveIdentifiables(A article, List<Identifiable> identifiables) {
        UUID uuid = article.getUuid();
        return this.saveIdentifiables(uuid, identifiables);
    }

    public List<Identifiable> saveIdentifiables(UUID identifiablesContainerUuid, List<Identifiable> identifiables) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM article_identifiables WHERE article_uuid = :uuid").bind("uuid", (Object)identifiablesContainerUuid)).execute());
        PreparedBatch batch = (PreparedBatch)this.dbi.withHandle(h -> h.prepareBatch("INSERT INTO article_identifiables(article_uuid, identifiable_uuid, sortIndex) VALUES(:uuid, :identifiableUuid, :sortIndex)"));
        for (Identifiable identifiable : identifiables) {
            ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("uuid", (Object)identifiablesContainerUuid)).bind("identifiableUuid", (Object)identifiable.getUuid())).bind("sortIndex", identifiables.indexOf(identifiable))).add();
        }
        int[] counts = batch.execute();
        return this.getIdentifiables(identifiablesContainerUuid);
    }
}

