/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.parts.Translation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.ContentNodeImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ContentNodeRepositoryImpl<C extends ContentNode, I extends Identifiable>
extends IdentifiableRepositoryImpl<C>
implements ContentNodeRepository<C, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodeRepositoryImpl.class);
    private final IdentifiableRepository identifiableRepository;
    private final LocaleRepository localeRepository;

    @Autowired
    public ContentNodeRepositoryImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository, LocaleRepository localeRepository, Jdbi dbi) {
        this.dbi = dbi;
        this.identifiableRepository = identifiableRepository;
        this.localeRepository = localeRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM contentnodes";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<C> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder().append("SELECT i.uuid as uuid, i.label as label, i.description as description").append(" FROM contentnodes cn INNER JOIN identifiables i ON cn.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ContentNodeImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public C findOne(UUID uuid) {
        StringBuilder query = new StringBuilder().append("SELECT i.uuid as uuid, i.label as label, i.description as description").append(" FROM contentnodes cn INNER JOIN identifiables i ON cn.uuid=i.uuid").append(" WHERE cn.uuid = :uuid");
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).mapToBean(ContentNodeImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        ContentNode contentNode = (ContentNode)list.get(0);
        contentNode.setChildren(this.getChildren(contentNode));
        contentNode.setIdentifiables(this.getIdentifiables(contentNode));
        return (C)contentNode;
    }

    public C findOne(UUID uuid, Locale locale) {
        Locale fLocale;
        C contentNode = this.findOne(uuid);
        Set translations = contentNode.getLabel().getTranslations();
        if (locale == null) {
            Optional translation2 = translations.stream().findFirst();
            locale = translation2.map(Translation::getLocale).orElse(null);
        }
        if ((fLocale = locale) == null) {
            return null;
        }
        boolean requestedTranslationExists = translations.stream().anyMatch(translation -> translation.getLocale().equals(fLocale));
        if (!requestedTranslationExists) {
            return null;
        }
        contentNode.getLabel().getTranslations().removeIf(translation -> !translation.getLocale().equals(fLocale));
        if (contentNode.getDescription() != null && contentNode.getDescription().getLocalizedStructuredContent() != null) {
            contentNode.getDescription().getLocalizedStructuredContent().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        return contentNode;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    public List<C> getChildren(C contentNode) {
        return this.getChildren(contentNode.getUuid());
    }

    public List<C> getChildren(UUID uuid) {
        StringBuilder query = new StringBuilder().append("SELECT i.uuid as uuid, i.label as label").append(" FROM contentnodes cn INNER JOIN contentnode_contentnode cc ON cn.uuid=cc.parent_contentnode_uuid INNER JOIN identifiables i ON cc.child_contentnode_uuid=i.uuid").append(" WHERE cn.uuid = :uuid").append(" ORDER BY cc.sortIndex ASC");
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).mapToBean(ContentNodeImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList();
        }
        return list.stream().map(s -> s).collect(Collectors.toList());
    }

    @Override
    public C save(C contentNode) {
        this.identifiableRepository.save(contentNode);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO contentnodes(uuid) VALUES (:uuid)").bindBean(contentNode)).execute());
        return this.findOne(contentNode.getUuid());
    }

    public C saveWithParentContentTree(C contentNode, UUID parentContentTreeUuid) {
        this.identifiableRepository.save(contentNode);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO contentnodes(uuid) VALUES (:uuid)").bindBean(contentNode)).execute());
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "contenttree_contentnode", "contenttree_uuid", parentContentTreeUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO contenttree_contentnode(contenttree_uuid, contentnode_uuid, sortIndex) VALUES (:parent_contenttree_uuid, :uuid, :sortIndex)").bind("parent_contenttree_uuid", (Object)parentContentTreeUuid)).bind("sortIndex", sortIndex)).bindBean(contentNode)).execute());
        return this.findOne(contentNode.getUuid());
    }

    public C saveWithParentContentNode(C contentNode, UUID parentContentNodeUuid) {
        this.identifiableRepository.save(contentNode);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO contentnodes(uuid) VALUES (:uuid)").bindBean(contentNode)).execute());
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "contentnode_contentnode", "parent_contentnode_uuid", parentContentNodeUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO contentnode_contentnode(parent_contentnode_uuid, child_contentnode_uuid, sortIndex) VALUES (:parent_contentnode_uuid, :uuid, :sortIndex)").bind("parent_contentnode_uuid", (Object)parentContentNodeUuid)).bind("sortIndex", sortIndex)).bindBean(contentNode)).execute());
        return this.findOne(contentNode.getUuid());
    }

    @Override
    public C update(C contentNode) {
        this.identifiableRepository.update(contentNode);
        return this.findOne(contentNode.getUuid());
    }

    public List<Identifiable> getIdentifiables(C contentNode) {
        return this.getIdentifiables(contentNode.getUuid());
    }

    public List<Identifiable> getIdentifiables(UUID uuid) {
        String query = "SELECT i.uuid as uuid, i.label as label FROM identifiables i INNER JOIN contentnode_identifiables ci ON ci.identifiable_uuid=i.uuid WHERE ci.contentnode_uuid = :uuid ORDER BY ci.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(IdentifiableImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<Identifiable>();
        }
        return list.stream().map(Identifiable.class::cast).collect(Collectors.toList());
    }

    public void addIdentifiable(UUID identifiablesContainerUuid, UUID identifiableUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "contentnode_identifiables", "contentnode_uuid", identifiablesContainerUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO contentnode_identifiables(contentnode_uuid, identifiable_uuid, sortIndex) VALUES (:contentnode_uuid, :identifiable_uuid, :sortIndex)").bind("contentnode_uuid", (Object)identifiablesContainerUuid)).bind("identifiable_uuid", (Object)identifiableUuid)).bind("sortIndex", sortIndex)).execute());
    }

    public List<Identifiable> saveIdentifiables(C contentNode, List<Identifiable> identifiables) {
        UUID uuid = contentNode.getUuid();
        return this.saveIdentifiables(uuid, identifiables);
    }

    public List<Identifiable> saveIdentifiables(UUID identifiablesContainerUuid, List<Identifiable> identifiables) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM contentnode_identifiables WHERE contentnode_uuid = :uuid").bind("uuid", (Object)identifiablesContainerUuid)).execute());
        PreparedBatch batch = (PreparedBatch)this.dbi.withHandle(h -> h.prepareBatch("INSERT INTO contentnode_identifiables(contentnode_uuid, identifiable_uuid, sortIndex) VALUES(:uuid, :identifiableUuid, :sortIndex)"));
        for (Identifiable identifiable : identifiables) {
            ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("uuid", (Object)identifiablesContainerUuid)).bind("identifiableUuid", (Object)identifiable.getUuid())).bind("sortIndex", identifiables.indexOf(identifiable))).add();
        }
        int[] counts = batch.execute();
        return this.getIdentifiables(identifiablesContainerUuid);
    }
}

