/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.identifiable.parts.Translation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl<W extends Webpage, I extends Identifiable>
extends IdentifiableRepositoryImpl<W>
implements WebpageRepository<W, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);
    private final IdentifiableRepository identifiableRepository;
    private final LocaleRepository localeRepository;

    @Autowired
    public WebpageRepositoryImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository, LocaleRepository localeRepository, Jdbi dbi) {
        this.dbi = dbi;
        this.identifiableRepository = identifiableRepository;
        this.localeRepository = localeRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM webpages";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<W> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder().append("SELECT wp.text as text, i.uuid as uuid, i.label as label, i.description as description").append(" FROM webpages wp INNER JOIN identifiables i ON wp.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(WebpageImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public W findOne(UUID uuid) {
        String query = "SELECT wp.text as text, i.uuid as uuid, i.label as label, i.description as description FROM webpages wp INNER JOIN identifiables i ON wp.uuid=i.uuid WHERE wp.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        Webpage webpage = (Webpage)list.get(0);
        webpage.setChildren(this.getChildren(webpage));
        webpage.setIdentifiables(this.getIdentifiables(webpage));
        return (W)webpage;
    }

    public W findOne(UUID uuid, Locale locale) {
        Locale fLocale;
        W webpage = this.findOne(uuid);
        Set translations = webpage.getLabel().getTranslations();
        if (locale == null) {
            Optional translation2 = translations.stream().findFirst();
            locale = translation2.map(Translation::getLocale).orElse(null);
        }
        if ((fLocale = locale) == null) {
            return null;
        }
        boolean requestedTranslationExists = translations.stream().anyMatch(translation -> translation.getLocale().equals(fLocale));
        if (!requestedTranslationExists) {
            return null;
        }
        webpage.getLabel().getTranslations().removeIf(translation -> !translation.getLocale().equals(fLocale));
        if (webpage.getDescription() != null && webpage.getDescription().getLocalizedStructuredContent() != null) {
            webpage.getDescription().getLocalizedStructuredContent().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        if (webpage.getText() != null && webpage.getText().getLocalizedStructuredContent() != null) {
            webpage.getText().getLocalizedStructuredContent().entrySet().removeIf(entry -> !entry.getKey().equals(fLocale));
        }
        return webpage;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    public List<W> getChildren(W webpage) {
        return this.getChildren(webpage.getUuid());
    }

    public List<W> getChildren(UUID uuid) {
        String query = "SELECT ww.child_webpage_uuid as uuid, i.label as label FROM webpages wp INNER JOIN webpage_webpage ww ON wp.uuid=ww.parent_webpage_uuid INNER JOIN identifiables i ON ww.child_webpage_uuid=i.uuid WHERE wp.uuid = :uuid ORDER BY ww.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList();
        }
        return list.stream().map(s -> s).collect(Collectors.toList());
    }

    @Override
    public W save(W webpage) {
        this.identifiableRepository.save(webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO webpages(uuid, text) VALUES (:uuid, :text::JSONB)").bindBean(webpage)).execute());
        return this.findOne(webpage.getUuid());
    }

    public W saveWithParentWebsite(W webpage, UUID parentWebsiteUuid) {
        this.identifiableRepository.save(webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO webpages(uuid, text) VALUES (:uuid, :text::JSONB)").bindBean(webpage)).execute());
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "website_webpage", "website_uuid", parentWebsiteUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO website_webpage(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :uuid, :sortIndex)").bind("parent_website_uuid", (Object)parentWebsiteUuid)).bind("sortIndex", sortIndex)).bindBean(webpage)).execute());
        return this.findOne(webpage.getUuid());
    }

    public W saveWithParentWebpage(W webpage, UUID parentWebpageUuid) {
        this.identifiableRepository.save(webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO webpages(uuid, text) VALUES (:uuid, :text::JSONB)").bindBean(webpage)).execute());
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "webpage_webpage", "parent_webpage_uuid", parentWebpageUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO webpage_webpage(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :uuid, :sortIndex)").bind("parent_webpage_uuid", (Object)parentWebpageUuid)).bind("sortIndex", sortIndex)).bindBean(webpage)).execute());
        return this.findOne(webpage.getUuid());
    }

    @Override
    public W update(W webpage) {
        this.identifiableRepository.update(webpage);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE webpages SET text=:text::JSONB WHERE uuid=:uuid").bindBean(webpage)).execute());
        return this.findOne(webpage.getUuid());
    }

    public List<Identifiable> getIdentifiables(W webpage) {
        return this.getIdentifiables(webpage.getUuid());
    }

    public List<Identifiable> getIdentifiables(UUID uuid) {
        String query = "SELECT i.uuid as uuid, i.label as label FROM identifiables i INNER JOIN webpage_identifiables wi ON wi.identifiable_uuid=i.uuid WHERE wi.webpage_uuid = :uuid ORDER BY wi.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(IdentifiableImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<Identifiable>();
        }
        return list.stream().map(Identifiable.class::cast).collect(Collectors.toList());
    }

    public void addIdentifiable(UUID webpageUuid, UUID identifiableUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "webpage_identifiables", "webpage_uuid", webpageUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO webpage_identifiables(webpage_uuid, identifiable_uuid, sortIndex) VALUES (:webpage_uuid, :identifiable_uuid, :sortIndex)").bind("webpage_uuid", (Object)webpageUuid)).bind("identifiable_uuid", (Object)identifiableUuid)).bind("sortIndex", sortIndex)).execute());
    }

    public List<Identifiable> saveIdentifiables(W webpage, List<Identifiable> identifiables) {
        UUID uuid = webpage.getUuid();
        return this.saveIdentifiables(uuid, identifiables);
    }

    public List<Identifiable> saveIdentifiables(UUID identifiablesContainerUuid, List<Identifiable> identifiables) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM webpage_identifiables WHERE webpagee_uuid = :uuid").bind("uuid", (Object)identifiablesContainerUuid)).execute());
        PreparedBatch batch = (PreparedBatch)this.dbi.withHandle(h -> h.prepareBatch("INSERT INTO webpage_identifiables(webpage_uuid, identifiable_uuid, sortIndex) VALUES(:uuid, :identifiableUuid, :sortIndex)"));
        for (Identifiable identifiable : identifiables) {
            ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("uuid", (Object)identifiablesContainerUuid)).bind("identifiableUuid", (Object)identifiable.getUuid())).bind("sortIndex", identifiables.indexOf(identifiable))).add();
        }
        int[] counts = batch.execute();
        return this.getIdentifiables(identifiablesContainerUuid);
    }
}

