/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    protected final Jdbi dbi;
    private final IdentifiableRepository identifiableRepository;

    @Autowired
    public EntityRepositoryImpl(Jdbi dbi, @Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository) {
        this.dbi = dbi;
        this.identifiableRepository = identifiableRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM entities";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<E> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT e.entity_type as entityType, e.uuid as uuid, i.label as label, i.description as description").append(" FROM entities e INNER JOIN identifiables i ON e.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(EntityImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public E findOne(UUID uuid) {
        String query = "SELECT e.entity_type as entityType, e.uuid as uuid, i.label as label, i.description as description FROM entities e INNER JOIN identifiables i ON e.uuid=i.uuid WHERE e.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(EntityImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (E)((Entity)list.get(0));
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "entityType", "lastModified"};
    }

    @Override
    public E save(E entity) {
        this.identifiableRepository.save(entity);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO entities(entity_type, uuid) VALUES (:entityType, :uuid)").bindBean(entity)).execute());
        return this.findOne(entity.getUuid());
    }

    @Override
    public E update(E entity) {
        this.identifiableRepository.update(entity);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE entities SET entity_type=:entityType WHERE uuid=:uuid").bindBean(entity)).execute());
        return this.findOne(entity.getUuid());
    }
}

