/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.LocaleRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl<W extends WebsiteImpl>
extends EntityRepositoryImpl<W>
implements WebsiteRepository<W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteRepositoryImpl.class);
    private final EntityRepository entityRepository;
    private final LocaleRepository localeRepository;

    @Autowired
    public WebsiteRepositoryImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository, @Qualifier(value="entityRepositoryImpl") EntityRepository entityRepository, LocaleRepository localeRepository, Jdbi dbi) {
        super(dbi, identifiableRepository);
        this.entityRepository = entityRepository;
        this.localeRepository = localeRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM websites";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<W> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT ws.id as id, ws.uuid as uuid, ws.url as url, ws.registration_date as registration_date, i.label as label, i.description as description").append(" FROM websites ws INNER JOIN entities e ON ws.uuid=e.uuid INNER JOIN identifiables i ON ws.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(WebsiteImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public W findOne(UUID uuid) {
        String query = "SELECT ws.uuid as uuid, ws.url as url, ws.registration_date as registration_date, i.label as label, i.description as description FROM websites ws INNER JOIN entities e ON ws.uuid=e.uuid INNER JOIN identifiables i ON ws.uuid=i.uuid WHERE ws.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebsiteImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        WebsiteImpl website = (WebsiteImpl)list.get(0);
        website.setRootPages(this.getRootPages(website));
        return (W)website;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"url"};
    }

    public List<Webpage> getRootPages(W website) {
        UUID uuid = website.getUuid();
        return this.getRootPages(uuid);
    }

    public List<Webpage> getRootPages(UUID uuid) {
        String query = "SELECT ww.webpage_uuid as uuid, i.label as label FROM websites ws INNER JOIN website_webpage ww ON ws.uuid=ww.website_uuid INNER JOIN identifiables i ON ww.webpage_uuid=i.uuid WHERE ws.uuid = :uuid ORDER BY ww.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<Webpage>();
        }
        return list.stream().map(WebpageImpl.class::cast).collect(Collectors.toList());
    }

    @Override
    public W save(W website) {
        this.entityRepository.save(website);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO websites(url, registration_date, uuid) VALUES (:url, :registrationDate, :uuid)").bindBean(website)).execute());
        return this.findOne(website.getUuid());
    }

    @Override
    public W update(W website) {
        this.entityRepository.update(website);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE websites SET url=:url, registration_date=:registrationDate WHERE uuid=:uuid").bindBean(website)).execute());
        return this.findOne(website.getUuid());
    }
}

