/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.commons.file.backend.api.FileResourceRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.CudamiFileResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.exceptions.ResourceIOException;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class CudamiFileResourceRepositoryImpl
extends IdentifiableRepositoryImpl<FileResource>
implements CudamiFileResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CudamiFileResourceRepositoryImpl.class);
    protected final Jdbi dbi;
    private final IdentifiableRepository identifiableRepository;
    @Autowired
    FileResourceRepository fileResourceRepository;

    @Autowired
    public CudamiFileResourceRepositoryImpl(Jdbi dbi, @Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository identifiableRepository) {
        this.dbi = dbi;
        this.identifiableRepository = identifiableRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM fileresources";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOnly());
        return count;
    }

    @Override
    public PageResponse<FileResource> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT f.filename as filename, f.mimetype as mimeType, f.size_in_bytes as sizeInBytes, i.uuid as uuid, i.label as label, i.description as description").append(" FROM fileresources f INNER JOIN identifiables i ON f.uuid=i.uuid");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(FileResourceImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public FileResource findOne(UUID uuid) {
        String query = "SELECT f.filename as filename, f.mimetype as mimeType, f.size_in_bytes as sizeInBytes, i.uuid as uuid, i.label as label, i.description as description FROM fileresources f INNER JOIN identifiables i ON f.uuid=i.uuid WHERE f.uuid = :uuid";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(FileResourceImpl.class).list());
        if (list.isEmpty()) {
            return null;
        }
        return (FileResource)list.get(0);
    }

    public FileResource save(FileResource fileResource, InputStream binaryData) {
        try {
            this.fileResourceRepository.write(fileResource, binaryData);
        }
        catch (ResourceIOException ex) {
            LOGGER.error("Error saving binary data of fileresource " + fileResource.getUuid().toString(), (Throwable)ex);
        }
        this.identifiableRepository.save((Identifiable)fileResource);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources(filename, mimetype, size_in_bytes, uuid) VALUES (:filename, :mimeType, :sizeInBytes, :uuid)").bindBean((Object)fileResource)).execute());
        return this.findOne(fileResource.getUuid());
    }

    @Override
    public FileResource update(FileResource fileresource) {
        this.identifiableRepository.update((Identifiable)fileresource);
        this.dbi.withHandle(h -> ((Update)h.createUpdate("UPDATE fileresources SET filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes WHERE uuid=:uuid").bindBean((Object)fileresource)).execute());
        return this.findOne(fileresource.getUuid());
    }
}

