/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRelationMapper;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.EntityRelation;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    @Autowired
    public EntityRepositoryImpl(Jdbi dbi) {
        super(dbi);
    }

    public void addRelatedFileresource(E entity, FileResource fileResource) {
        this.addRelatedFileresource(entity.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "rel_entity_fileresources", "entity_uuid", entityUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortindex) VALUES (:entity_uuid, :fileresource_uuid, :sortindex)").bind("entity_uuid", (Object)entityUuid)).bind("fileresource_uuid", (Object)fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelation(EntityRelation<E> relation) {
        this.addRelation(relation.getSubject().getUuid(), relation.getPredicate(), relation.getObject().getUuid());
    }

    public void addRelation(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) {
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entity_entities(subject_uuid, predicate, object_uuid) VALUES (:subject_uuid, :predicate, :object_uuid)").bind("subject_uuid", (Object)subjectEntityUuid)).bind("predicate", predicate)).bind("object_uuid", (Object)objectEntityUuid)).execute());
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM entities";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<E> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT uuid, created, description, label, last_modified, entityType").append(" FROM entities");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(EntityImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public E findOne(UUID uuid) {
        String query = "SELECT uuid, created, description, label, last_modified, entityType FROM entities WHERE uuid = :uuid";
        Entity entity = (Entity)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(EntityImpl.class).findOne().orElse(null));
        return (E)entity;
    }

    @Override
    public E findOne(Identifier identifier) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "entity_type", "last_modified"};
    }

    private int getIndex(LinkedHashSet<FileResource> fileResources, FileResource fileResource) {
        boolean found = false;
        int pos = -1;
        Iterator iterator = fileResources.iterator();
        while (iterator.hasNext()) {
            ++pos;
            FileResource fr = (FileResource)iterator.next();
            if (!fr.getUuid().equals(fileResource.getUuid())) continue;
            found = true;
            break;
        }
        if (found) {
            return pos;
        }
        return -1;
    }

    public LinkedHashSet<FileResource> getRelatedFileResources(E entity) {
        return this.getRelatedFileResources(entity.getUuid());
    }

    public LinkedHashSet<FileResource> getRelatedFileResources(UUID entityUuid) {
        StringBuilder query = new StringBuilder("SELECT *").append(" FROM fileresources f INNER JOIN rel_entity_fileresources ref ON f.uuid=ref.fileresource_uuid").append(" WHERE ref.entity_uuid = :entityUuid").append(" ORDER BY ref.sortindex");
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("entityUuid", (Object)entityUuid)).mapToBean(FileResourceImpl.class).list());
        return new LinkedHashSet<FileResource>(result);
    }

    public List<EntityRelation> getRelations(E subjectEntity) {
        StringBuilder query = new StringBuilder("SELECT rel.predicate as predicate,").append(" e.uuid as uuid, e.created as created, e.description as description, e.identifiable_type as identifiable_type, e.label as label, e.last_modified as last_modified, e.entity_type as entity_type").append(" FROM rel_entity_entities rel INNER JOIN entities e ON rel.object_uuid=e.uuid").append(" WHERE rel.subject_uuid = :uuid");
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("uuid", (Object)subjectEntity.getUuid())).map(new EntityRelationMapper<Entity>((Entity)subjectEntity)).list());
        return result;
    }

    public List<EntityRelation> getRelations(UUID subjectEntityUuid) {
        E subjectEntity = this.findOne(subjectEntityUuid);
        return this.getRelations(subjectEntity);
    }

    @Override
    public E save(E entity) {
        throw new UnsupportedOperationException("use save of specific/inherited entity repository");
    }

    public LinkedHashSet<FileResource> saveRelatedFileResources(E entity, LinkedHashSet<FileResource> fileResources) {
        return this.saveRelatedFileResources(entity.getUuid(), fileResources);
    }

    public LinkedHashSet<FileResource> saveRelatedFileResources(UUID entityUuid, LinkedHashSet<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entity_fileresources WHERE entity_uuid = :uuid").bind("uuid", (Object)entityUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)entityUuid)).bind("fileResourceUuid", (Object)fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.getRelatedFileResources(entityUuid);
    }

    public List<EntityRelation> saveRelations(List<EntityRelation> relations) {
        if (relations == null) {
            return null;
        }
        UUID subjectUuid = relations.get(0).getSubject().getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entity_entities WHERE entity_uuid = :uuid").bind("uuid", (Object)subjectUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_entities(subject_uuid, predicate, object_uuid) VALUES(:subjectUuid, :predicate, :objectUuid)");
            for (EntityRelation relation : relations) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("subjectUuid", (Object)subjectUuid)).bind("predicate", relation.getPredicate())).bind("objectUuid", (Object)relation.getObject().getUuid())).add();
            }
            preparedBatch.execute();
        });
        return this.getRelations(subjectUuid);
    }

    @Override
    public E update(E entity) {
        throw new UnsupportedOperationException("use update of specific/inherited entity repository");
    }
}

