/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.ContentNodeRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.ContentNode;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.ContentNodeImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ContentNodeRepositoryImpl<E extends Entity>
extends EntityPartRepositoryImpl<ContentNode, E>
implements ContentNodeRepository<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentNodeRepositoryImpl.class);

    @Autowired
    public ContentNodeRepositoryImpl(Jdbi dbi) {
        super(dbi);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM contentnodes";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<ContentNode> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder().append("SELECT uuid, created, description, label, last_modified").append(" FROM contentnodes");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ContentNodeImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public ContentNode findOne(UUID uuid) {
        StringBuilder query = new StringBuilder().append("SELECT uuid, created, description, label, last_modified").append(" FROM contentnodes").append(" WHERE uuid = :uuid");
        ContentNode contentNode = (ContentNode)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).mapToBean(ContentNodeImpl.class).findOne().orElse(null));
        if (contentNode != null) {
            contentNode.setChildren(this.getChildren(contentNode));
        }
        return contentNode;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    public ContentNode getParent(UUID uuid) {
        StringBuilder query = new StringBuilder().append("SELECT uuid, created, description, label, last_modified").append(" FROM contentnodes INNER JOIN contentnode_contentnodes cc ON uuid = cc.parent_contentnode_uuid").append(" WHERE cc.child_contentnode_uuid = :uuid");
        ContentNode contentNode = (ContentNode)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).mapToBean(ContentNodeImpl.class).findOne().orElse(null));
        return contentNode;
    }

    public List<ContentNode> getChildren(ContentNode contentNode) {
        return this.getChildren(contentNode.getUuid());
    }

    public List<ContentNode> getChildren(UUID uuid) {
        String sql = "SELECT uuid, created, description, label, last_modified FROM contentnodes INNER JOIN contentnode_contentnodes cc ON uuid = cc.child_contentnode_uuid WHERE cc.parent_contentnode_uuid = :uuid ORDER BY cc.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", (Object)uuid)).mapToBean(ContentNodeImpl.class).list());
        if (list.isEmpty()) {
            return new ArrayList<ContentNode>();
        }
        return list.stream().map(s -> s).collect(Collectors.toList());
    }

    public LinkedHashSet<E> getEntities(ContentNode contentNode) {
        return this.getEntities(contentNode.getUuid());
    }

    public LinkedHashSet<E> getEntities(UUID contentNodeUuid) {
        String sql = "SELECT uuid, created, description, label, last_modified, entity_type FROM entities INNER JOIN contentnode_entities ce ON uuid = ce.entity_uuid WHERE ce.contentnode_uuid = :uuid ORDER BY ce.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", (Object)contentNodeUuid)).mapToBean(EntityImpl.class).list());
        if (list.isEmpty()) {
            return new LinkedHashSet();
        }
        LinkedHashSet result = list.stream().map(s -> s).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    public LinkedHashSet<FileResource> getFileResources(ContentNode contentNode) {
        return this.getFileResources(contentNode.getUuid());
    }

    public LinkedHashSet<FileResource> getFileResources(UUID contentNodeUuid) {
        String sql = "SELECT uuid, created, description, label, last_modified, filename, mimetype, size_in_bytes, uri FROM fileresources INNER JOIN contentnode_fileresources cf ON uuid = cf.fileresource_uuid WHERE cf.contentnode_uuid = :uuid ORDER BY cf.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", (Object)contentNodeUuid)).mapToBean(FileResourceImpl.class).list());
        if (list.isEmpty()) {
            return new LinkedHashSet<FileResource>();
        }
        LinkedHashSet result = list.stream().map(s -> s).collect(Collectors.toCollection(LinkedHashSet::new));
        return result;
    }

    @Override
    public ContentNode save(ContentNode contentNode) {
        contentNode.setUuid(UUID.randomUUID());
        contentNode.setCreated(LocalDateTime.now());
        contentNode.setLastModified(LocalDateTime.now());
        ContentNode result = (ContentNode)this.dbi.withHandle(h -> ((Query)h.createQuery("INSERT INTO contentnodes(uuid, created, description, identifiable_type, label, last_modified) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified) RETURNING *").bindBean((Object)contentNode)).mapToBean(ContentNodeImpl.class).findOne().orElse(null));
        return result;
    }

    public LinkedHashSet<E> saveEntities(ContentNode contentNode, LinkedHashSet<E> entities) {
        return this.saveEntities(contentNode.getUuid(), entities);
    }

    public LinkedHashSet<E> saveEntities(UUID contentNodeUuid, LinkedHashSet<E> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM contentnode_entities WHERE contentnode_uuid = :uuid").bind("uuid", (Object)contentNodeUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO contentnode_entities(contentnode_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)contentNodeUuid)).bind("entityUuid", (Object)entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getEntities(contentNodeUuid);
    }

    public LinkedHashSet<FileResource> saveFileResources(ContentNode contentNode, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(contentNode.getUuid(), fileResources);
    }

    public LinkedHashSet<FileResource> saveFileResources(UUID contentNodeUuid, LinkedHashSet<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM contentnode_fileresources WHERE contentnode_uuid = :uuid").bind("uuid", (Object)contentNodeUuid)).execute());
        if (fileResources != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO contentnode_fileresources(contentnode_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)contentNodeUuid)).bind("fileResourceUuid", (Object)fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(contentNodeUuid);
    }

    public ContentNode saveWithParentContentNode(ContentNode contentNode, UUID parentContentNodeUuid) {
        ContentNode savedContentNode = this.save(contentNode);
        Integer sortindex = this.selectNextSortIndexForParentChildren(this.dbi, "contentnode_contentnodes", "parent_contentnode_uuid", parentContentNodeUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO contentnode_contentnodes(parent_contentnode_uuid, child_contentnode_uuid, sortindex) VALUES (:parent_contentnode_uuid, :uuid, :sortindex)").bind("parent_contentnode_uuid", (Object)parentContentNodeUuid)).bind("sortindex", sortindex)).bindBean((Object)savedContentNode)).execute());
        return this.findOne(savedContentNode.getUuid());
    }

    public ContentNode saveWithParentContentTree(ContentNode contentNode, UUID parentContentTreeUuid) {
        ContentNode savedContentNode = this.save(contentNode);
        Integer sortindex = this.selectNextSortIndexForParentChildren(this.dbi, "contenttree_contentnodes", "contenttree_uuid", parentContentTreeUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO contenttree_contentnodes(contenttree_uuid, contentnode_uuid, sortindex) VALUES (:parent_contenttree_uuid, :uuid, :sortindex)").bind("parent_contenttree_uuid", (Object)parentContentTreeUuid)).bind("sortindex", sortindex)).bindBean((Object)savedContentNode)).execute());
        return this.findOne(savedContentNode.getUuid());
    }

    @Override
    public ContentNode update(ContentNode contentNode) {
        contentNode.setLastModified(LocalDateTime.now());
        ContentNode result = (ContentNode)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE contentnodes SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified WHERE uuid=:uuid RETURNING *").bindBean((Object)contentNode)).mapToBean(ContentNodeImpl.class).findOne().orElse(null));
        return result;
    }
}

