/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.model.api.identifiable.parts.LocalizedText;
import de.digitalcollections.model.api.identifiable.parts.structuredcontent.LocalizedStructuredContent;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.impl.identifiable.resource.ApplicationFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.AudioFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.LinkedDataFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.TextFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.VideoFileResourceImpl;
import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.ColumnMappers;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class FileResourceMapper
implements RowMapper<FileResource> {
    public FileResource map(ResultSet rs, StatementContext ctx) throws SQLException {
        AudioFileResourceImpl result;
        ConfigRegistry config = ctx.getConfig();
        ColumnMappers columnMappers = (ColumnMappers)config.get(ColumnMappers.class);
        ColumnMapper lscMapper = (ColumnMapper)columnMappers.findFor(LocalizedStructuredContent.class).orElseThrow(() -> new NoSuchMapperException("LocalizedStructuredContent"));
        ColumnMapper ltMapper = (ColumnMapper)columnMappers.findFor(LocalizedText.class).orElseThrow(() -> new NoSuchMapperException("LocalizedText"));
        String mimeType = rs.getString("mimetype");
        String primaryType = "application";
        String subType = null;
        if (mimeType != null) {
            primaryType = mimeType.substring(0, mimeType.indexOf("/"));
            subType = mimeType.substring(mimeType.lastIndexOf("/") + 1);
        }
        switch (primaryType) {
            case "audio": {
                result = new AudioFileResourceImpl();
                break;
            }
            case "image": {
                result = new ImageFileResourceImpl();
                break;
            }
            case "text": {
                result = new TextFileResourceImpl();
                break;
            }
            case "video": {
                result = new VideoFileResourceImpl();
                break;
            }
            case "application": {
                if ("ld+json".equals(subType)) {
                    result = new LinkedDataFileResourceImpl();
                    break;
                }
                result = new ApplicationFileResourceImpl();
                break;
            }
            default: {
                result = new ApplicationFileResourceImpl();
            }
        }
        result.setCreated(rs.getTimestamp("created").toLocalDateTime());
        result.setDescription((LocalizedStructuredContent)lscMapper.map(rs, "description", ctx));
        result.setLabel((LocalizedText)ltMapper.map(rs, "label", ctx));
        result.setLastModified(rs.getTimestamp("last_modified").toLocalDateTime());
        result.setUuid(rs.getObject("uuid", UUID.class));
        result.setFilename(rs.getString("filename"));
        result.setMimeType(MimeType.fromTypename((String)mimeType));
        result.setSizeInBytes(rs.getLong("size_in_bytes"));
        String uriStr = rs.getString("uri");
        if (uriStr != null) {
            result.setUri(URI.create(uriStr));
        }
        return result;
    }
}

