/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMapper;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.api.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.TextFileResource;
import de.digitalcollections.model.api.identifiable.resource.VideoFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.resource.ApplicationFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.AudioFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.LinkedDataFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.TextFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.VideoFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FileResourceMetadataRepositoryImpl
extends IdentifiableRepositoryImpl<FileResource>
implements FileResourceMetadataRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataRepositoryImpl.class);
    static final String SELECT_ALL = "select f.uuid f_uuid, created f_created, description f_description, identifiable_type f_identifiable_type, label f_label, last_modified f_last_modified, filename f_filename, mimetype f_mimetype, size_in_bytes f_size_in_bytes, uri f_uri, id.uuid id_uuid, identifiable id_identifiable, namespace id_namespace, identifier id_id from fileresources as f left join identifiers as id on f.uuid = id.identifiable";
    private final IdentifierRepository identifierRepository;

    @Autowired
    public FileResourceMetadataRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi);
        this.identifierRepository = identifierRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM fileresources";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public FileResource createByMimeType(MimeType mimeType) {
        AudioFileResourceImpl result;
        String primaryType;
        if (mimeType == null) {
            mimeType = MimeType.MIME_APPLICATION_OCTET_STREAM;
        }
        switch (primaryType = mimeType.getPrimaryType()) {
            case "audio": {
                result = new AudioFileResourceImpl();
                break;
            }
            case "image": {
                result = new ImageFileResourceImpl();
                break;
            }
            case "text": {
                result = new TextFileResourceImpl();
                break;
            }
            case "video": {
                result = new VideoFileResourceImpl();
                break;
            }
            case "application": {
                if ("ld+json".equals(mimeType.getSubType())) {
                    result = new LinkedDataFileResourceImpl();
                    break;
                }
                result = new ApplicationFileResourceImpl();
                break;
            }
            default: {
                result = new ApplicationFileResourceImpl();
            }
        }
        result.setMimeType(mimeType);
        UUID uuid = UUID.randomUUID();
        result.setUuid(uuid);
        return result;
    }

    @Override
    public PageResponse<FileResource> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT uuid, created, description, label, last_modified, filename, mimetype, size_in_bytes, uri").append(" FROM fileresources");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).map((RowMapper)new FileResourceMapper()).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public FileResource findOne(UUID uuid) {
        StringBuilder query = new StringBuilder(SELECT_ALL).append(" WHERE f.uuid = :uuid");
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            FileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (FileResource)rowView.getRow(FileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        FileResource fileResource = (FileResource)fileResourceOpt.get();
        this.addSpecificMetadata(fileResource, uuid);
        return fileResource;
    }

    private void addSpecificMetadata(FileResource fileResource, UUID uuid) {
        if (!(fileResource instanceof ApplicationFileResource)) {
            if (fileResource instanceof AudioFileResource) {
                int result = (Integer)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT duration FROM fileresources_audio WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapTo(Integer.class).findOne().orElse(null));
                ((AudioFileResource)fileResource).setDuration(result);
            } else if (fileResource instanceof ImageFileResource) {
                Map result = (Map)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT width, height FROM fileresources_image WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToMap().findOne().orElse(null));
                ((ImageFileResource)fileResource).setWidth(((Integer)result.get("width")).intValue());
                ((ImageFileResource)fileResource).setHeight(((Integer)result.get("height")).intValue());
            } else if (fileResource instanceof LinkedDataFileResource) {
                Map result = (Map)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT context, object_type FROM fileresources_linkeddata WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToMap().findOne().orElse(null));
                ((LinkedDataFileResource)fileResource).setContext(URI.create((String)result.get("context")));
                ((LinkedDataFileResource)fileResource).setObjectType((String)result.get("object_type"));
            } else if (!(fileResource instanceof TextFileResource) && fileResource instanceof VideoFileResource) {
                int result = (Integer)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT duration FROM fileresources_video WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapTo(Integer.class).findOne().orElse(null));
                ((VideoFileResource)fileResource).setDuration(result);
            }
        }
    }

    @Override
    public FileResource findOne(Identifier identifier) {
        if (identifier.getUuid() != null) {
            return this.findOne(identifier.getUuid());
        }
        String namespace = identifier.getNamespace();
        String id = identifier.getId();
        String query = "select f.* from fileresources as f left join identifiers as id on f.uuid = id.identifiable left join digitalobject_fileresources as df on df.fileresource_uuid = f.uuid left join digitalobjects as di on di.uuid = df.digitalobject_uuid left join versions as v on di.version = v.uuid where id.identifier = :id and id.namespace = :namespace and v.status = 'active'";
        FileResource fileResource = (FileResource)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query).bind("id", id)).bind("namespace", namespace)).map((RowMapper)new FileResourceMapper()).findOne().orElse(null));
        this.addSpecificMetadata(fileResource, fileResource.getUuid());
        return fileResource;
    }

    @Override
    public FileResource save(FileResource fileResource) {
        if (fileResource.getUuid() == null) {
            fileResource.setUuid(UUID.randomUUID());
        }
        fileResource.setCreated(LocalDateTime.now());
        fileResource.setLastModified(LocalDateTime.now());
        String baseColumnsSql = "uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri";
        String basePropertiesSql = ":uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri";
        if (fileResource instanceof ApplicationFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_application(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof AudioFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_audio(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof ImageFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_image(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, width, height) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :width, :height)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof LinkedDataFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_linkeddata(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, context, object_type) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :context, :objectType)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof TextFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_text(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof VideoFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_video(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bindBean((Object)fileResource)).execute());
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        List identifiers = fileResource.getIdentifiers();
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(fileResource.getUuid());
                this.identifierRepository.save(identifier);
            }
        }
        FileResource dbFileResource = this.findOne(fileResource.getUuid());
        return dbFileResource;
    }

    @Override
    public FileResource update(FileResource fileResource) {
        FileResource result;
        fileResource.setLastModified(LocalDateTime.now());
        String baseColumnsSql = "description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri";
        if (fileResource instanceof ApplicationFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_application SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(ApplicationFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof AudioFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_audio SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, duration=:duration WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(AudioFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof ImageFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_image SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, width=:width, height=:height WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(ImageFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof LinkedDataFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_linkeddata SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, context=:context, object_type=:objectType WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(LinkedDataFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof TextFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_text SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(TextFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof VideoFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_video SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, duration=:duration WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(VideoFileResourceImpl.class).findOne().orElse(null));
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        return result;
    }
}

