/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends AbstractPagingAndSortingRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    protected Jdbi dbi;

    @Autowired
    public IdentifiableRepositoryImpl(Jdbi dbi) {
        this.dbi = dbi;
    }

    public long count() {
        String sql = "SELECT count(*) FROM identifiables";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT * FROM identifiables");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(IdentifiableImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public List<I> find(String searchTerm, int maxResults) {
        StringBuilder query = new StringBuilder("WITH flattened AS (SELECT uuid, label, description, identifiable_type, jsonb_array_elements(label#>'{translations}')->>'text' AS text FROM identifiables)");
        query.append(" SELECT uuid, label, description, identifiable_type FROM flattened WHERE text ILIKE '%' || :searchTerm || '%'");
        query.append(" LIMIT :maxResults");
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchTerm)).bind("maxResults", maxResults)).mapToBean(IdentifiableImpl.class).stream().map(s -> s).collect(Collectors.toList()));
        return result;
    }

    public I findOne(UUID uuid) {
        Identifiable identifiable = (Identifiable)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM identifiables WHERE uuid = :uuid").bind("uuid", (Object)uuid)).mapToBean(IdentifiableImpl.class).findOne().orElse(null));
        return (I)identifiable;
    }

    public I findOne(Identifier identifier) {
        throw new UnsupportedOperationException("Not supported. Use findOne of specific/inherited identifiable repository.");
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "type", "last_modified"};
    }

    public I save(I identifiable) {
        throw new UnsupportedOperationException("use save of specific/inherited identifiable repository");
    }

    public I update(I identifiable) {
        throw new UnsupportedOperationException("use update of specific/inherited identifiable repository");
    }

    protected Integer selectNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT MAX(sortIndex) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", (Object)parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        if (sortIndex == null) {
            sortIndex = 0;
        }
        Integer sortIndexDb = sortIndex;
        return sortIndexDb;
    }

    protected int getIndex(LinkedHashSet<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ++pos;
            Identifiable idf = (Identifiable)iterator.next();
            if (!idf.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }
}

