/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ProjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ProjectImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectRepositoryImpl
extends EntityRepositoryImpl<Project>
implements ProjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRepositoryImpl.class);

    @Autowired
    public ProjectRepositoryImpl(Jdbi dbi) {
        super(dbi);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM projects";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Project> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT uuid, label, description, created, last_modified, text FROM projects");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(ProjectImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Project findOne(UUID uuid) {
        String query = "SELECT uuid, label, description, created, last_modified, text FROM projects WHERE uuid = :uuid";
        Project project = (Project)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(ProjectImpl.class).findOne().orElse(null));
        return project;
    }

    @Override
    public Project findOne(Identifier identifier) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    @Override
    public Project save(Project project) {
        project.setUuid(UUID.randomUUID());
        project.setCreated(LocalDateTime.now());
        project.setLastModified(LocalDateTime.now());
        String query = "INSERT INTO projects(uuid, label, description, identifiable_type, entity_type, created, last_modified, text) VALUES (:uuid, :label::JSONB, :description::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB) RETURNING *";
        Project result = (Project)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)project)).mapToBean(ProjectImpl.class).findOne().orElse(null));
        return result;
    }

    @Override
    public Project update(Project project) {
        project.setLastModified(LocalDateTime.now());
        String query = "UPDATE projects SET label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified, text=:text::JSONB WHERE uuid=:uuid RETURNING *";
        Project result = (Project)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)project)).mapToBean(ProjectImpl.class).findOne().orElse(null));
        return result;
    }
}

