/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl<E extends Entity>
extends EntityPartRepositoryImpl<Webpage, E>
implements WebpageRepository<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);

    @Autowired
    public WebpageRepositoryImpl(Jdbi dbi) {
        super(dbi);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM webpages";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Webpage> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT uuid, label, description, created, last_modified, text FROM webpages");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(WebpageImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Webpage findOne(UUID uuid) {
        String query = "SELECT uuid, label, description, created, last_modified, text FROM webpages WHERE uuid = :uuid";
        Webpage webpage = (Webpage)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).findOne().orElse(null));
        if (webpage != null) {
            webpage.setChildren(this.getChildren(webpage));
        }
        return webpage;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"uuid"};
    }

    public List<Webpage> getChildren(Webpage webpage) {
        return this.getChildren(webpage.getUuid());
    }

    public List<Webpage> getChildren(UUID uuid) {
        String sql = "SELECT uuid, created, description, label, last_modified FROM webpages INNER JOIN webpage_webpages ww ON uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid ORDER BY ww.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        return list.stream().map(s -> s).collect(Collectors.toList());
    }

    public Webpage getParent(UUID uuid) {
        String query = "SELECT uuid, label, description, created, last_modified FROM webpages INNER JOIN webpage_webpages ww ON uuid = ww.parent_webpage_uuid WHERE ww.child_webpage_uuid = :uuid";
        Webpage webpage = (Webpage)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).findOne().orElse(null));
        return webpage;
    }

    @Override
    public Webpage save(Webpage webpage) {
        webpage.setUuid(UUID.randomUUID());
        webpage.setCreated(LocalDateTime.now());
        webpage.setLastModified(LocalDateTime.now());
        String query = "INSERT INTO webpages(uuid, label, description, identifiable_type, created, last_modified, text) VALUES (:uuid, :label::JSONB, :description::JSONB, :type, :created, :lastModified, :text::JSONB) RETURNING *";
        Webpage result = (Webpage)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)webpage)).mapToBean(WebpageImpl.class).findOne().orElse(null));
        return result;
    }

    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) {
        Webpage savedWebpage = this.save(webpage);
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentWebpageUuid);
        String query = "INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_webpage_uuid", (Object)parentWebpageUuid)).bind("sortIndex", sortIndex)).bindBean((Object)savedWebpage)).execute());
        return this.findOne(savedWebpage.getUuid());
    }

    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) {
        Webpage savedWebpage = this.save(webpage);
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "website_webpages", "website_uuid", parentWebsiteUuid);
        String query = "INSERT INTO website_webpages(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_website_uuid", (Object)parentWebsiteUuid)).bind("sortIndex", sortIndex)).bindBean((Object)savedWebpage)).execute());
        return this.findOne(savedWebpage.getUuid());
    }

    @Override
    public Webpage update(Webpage webpage) {
        webpage.setLastModified(LocalDateTime.now());
        String query = "UPDATE webpages SET label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified, text=:text::JSONB WHERE uuid=:uuid RETURNING *";
        Webpage result = (Webpage)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)webpage)).mapToBean(WebpageImpl.class).findOne().orElse(null));
        return result;
    }
}

