/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.api.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.TextFileResource;
import de.digitalcollections.model.api.identifiable.resource.VideoFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.resource.ApplicationFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.AudioFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.LinkedDataFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.TextFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.VideoFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FileResourceMetadataRepositoryImpl
extends IdentifiableRepositoryImpl<FileResource>
implements FileResourceMetadataRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataRepositoryImpl.class);
    private final IdentifierRepository identifierRepository;

    @Autowired
    public FileResourceMetadataRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi);
        this.identifierRepository = identifierRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM fileresources";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public FileResource createByMimeType(MimeType mimeType) {
        AudioFileResourceImpl result;
        String primaryType;
        if (mimeType == null) {
            mimeType = MimeType.MIME_APPLICATION_OCTET_STREAM;
        }
        switch (primaryType = mimeType.getPrimaryType()) {
            case "audio": {
                result = new AudioFileResourceImpl();
                break;
            }
            case "image": {
                result = new ImageFileResourceImpl();
                break;
            }
            case "text": {
                result = new TextFileResourceImpl();
                break;
            }
            case "video": {
                result = new VideoFileResourceImpl();
                break;
            }
            case "application": {
                if ("ld+json".equals(mimeType.getSubType())) {
                    result = new LinkedDataFileResourceImpl();
                    break;
                }
                result = new ApplicationFileResourceImpl();
                break;
            }
            default: {
                result = new ApplicationFileResourceImpl();
            }
        }
        result.setMimeType(mimeType);
        UUID uuid = UUID.randomUUID();
        result.setUuid(uuid);
        return result;
    }

    @Override
    public PageResponse<FileResource> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT uuid, label, description, created, last_modified, filename, mimetype, size_in_bytes, uri FROM fileresources");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(FileResourceImpl.class).list());
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public FileResource findOne(UUID uuid) {
        String query = "SELECT mimetype FROM fileresources WHERE uuid=:uuid";
        String mimetype = (String)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapTo(String.class).findOne().orElse(null));
        if (mimetype == null) {
            return null;
        }
        FileResource typedFileResource = this.createByMimeType(MimeType.fromTypename((String)mimetype));
        if (typedFileResource instanceof ApplicationFileResource) {
            return this.findOneApplicationFileResource(uuid);
        }
        if (typedFileResource instanceof AudioFileResource) {
            return this.findOneAudioFileResource(uuid);
        }
        if (typedFileResource instanceof ImageFileResource) {
            return this.findOneImageFileResource(uuid);
        }
        if (typedFileResource instanceof LinkedDataFileResource) {
            return this.findOneLinkedDataFileResource(uuid);
        }
        if (typedFileResource instanceof TextFileResource) {
            return this.findOneTextFileResource(uuid);
        }
        if (typedFileResource instanceof VideoFileResource) {
            return this.findOneVideoFileResource(uuid);
        }
        return null;
    }

    @Override
    public FileResource findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "select f.* from fileresources as f left join identifiers as id on f.uuid = id.identifiable left join digitalobject_fileresources as df on df.fileresource_uuid = f.uuid left join digitalobjects as di on di.uuid = df.digitalobject_uuid left join versions as v on di.version = v.uuid where id.identifier = :id and id.namespace = :namespace and v.status = 'active'";
        String id = identifier.getId();
        FileResource fileResource = (FileResource)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query).bind("id", id)).bind("namespace", namespace)).mapToBean(FileResourceImpl.class).findOne().orElse(null));
        if (fileResource == null) {
            return null;
        }
        return this.findOne(fileResource.getUuid());
    }

    private ApplicationFileResource findOneApplicationFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_application as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ApplicationFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ApplicationFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (ApplicationFileResource)rowView.getRow(ApplicationFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (ApplicationFileResource)fileResourceOpt.get();
    }

    private AudioFileResource findOneAudioFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, f.duration f_duration, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_audio as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(AudioFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            AudioFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (AudioFileResource)rowView.getRow(AudioFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (AudioFileResource)fileResourceOpt.get();
    }

    private ImageFileResource findOneImageFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, f.height f_height, f.width f_width, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_image as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ImageFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (ImageFileResource)fileResourceOpt.get();
    }

    private LinkedDataFileResource findOneLinkedDataFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, f.context, f.object_type, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_linkeddata as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(LinkedDataFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            LinkedDataFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (LinkedDataFileResource)rowView.getRow(LinkedDataFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (LinkedDataFileResource)fileResourceOpt.get();
    }

    private TextFileResource findOneTextFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_text as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(TextFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            TextFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (TextFileResource)rowView.getRow(TextFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (TextFileResource)fileResourceOpt.get();
    }

    private VideoFileResource findOneVideoFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_identifiable_type, f.created f_created, f.last_modified f_last_modified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_size_in_bytes, f.uri f_uri, f.duration f_duration, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id FROM fileresources_video as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE f.uuid = :uuid";
        Optional fileResourceOpt = (Optional)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(VideoFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            VideoFileResource fr = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), id -> (VideoFileResource)rowView.getRow(VideoFileResourceImpl.class));
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                fr.addIdentifier((Identifier)rowView.getRow(IdentifierImpl.class));
            }
            return map;
        })).values().stream().findFirst());
        if (!fileResourceOpt.isPresent()) {
            return null;
        }
        return (VideoFileResource)fileResourceOpt.get();
    }

    @Override
    public FileResource save(FileResource fileResource) {
        if (fileResource.getUuid() == null) {
            fileResource.setUuid(UUID.randomUUID());
        }
        fileResource.setCreated(LocalDateTime.now());
        fileResource.setLastModified(LocalDateTime.now());
        String baseColumnsSql = "uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri";
        String basePropertiesSql = ":uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri";
        if (fileResource instanceof ApplicationFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_application(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof AudioFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_audio(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof ImageFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_image(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, width, height) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :width, :height)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof LinkedDataFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_linkeddata(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, context, object_type) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :context, :objectType)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof TextFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_text(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof VideoFileResource) {
            this.dbi.withHandle(h -> ((Update)h.createUpdate("INSERT INTO fileresources_video(uuid, created, description, identifiable_type, label, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bindBean((Object)fileResource)).execute());
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        List identifiers = fileResource.getIdentifiers();
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(fileResource.getUuid());
                this.identifierRepository.save(identifier);
            }
        }
        FileResource dbFileResource = this.findOne(fileResource.getUuid());
        return dbFileResource;
    }

    @Override
    public FileResource update(FileResource fileResource) {
        FileResource result;
        fileResource.setLastModified(LocalDateTime.now());
        String baseColumnsSql = "description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri";
        if (fileResource instanceof ApplicationFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_application SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(ApplicationFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof AudioFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_audio SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, duration=:duration WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(AudioFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof ImageFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_image SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, width=:width, height=:height WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(ImageFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof LinkedDataFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_linkeddata SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, context=:context, object_type=:objectType WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(LinkedDataFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof TextFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_text SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(TextFileResourceImpl.class).findOne().orElse(null));
        } else if (fileResource instanceof VideoFileResource) {
            result = (FileResource)this.dbi.withHandle(h -> ((Query)h.createQuery("UPDATE fileresources_video SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, filename=:filename, mimetype=:mimeType, size_in_bytes=:sizeInBytes, uri=:uri, duration=:duration WHERE uuid=:uuid RETURNING *").bindBean((Object)fileResource)).mapToBean(VideoFileResourceImpl.class).findOne().orElse(null));
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        return result;
    }
}

