/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.jdbi.DcCommonsJdbiPlugin;
import de.digitalcollections.cudami.server.backend.impl.jdbi.plugins.JsonbJdbiPlugin;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DataSourceConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.flywaydb.core.Flyway;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.spring4.JdbiFactoryBean;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.cudami.server.backend.impl.jdbi"})
public class SpringConfigBackendDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigBackendDatabase.class);
    @Value(value="${cudami.database.name}")
    private String databaseName;
    @Value(value="${cudami.database.hostname}")
    private String databaseHostname;
    @Value(value="${cudami.database.password}")
    private String databasePassword;
    @Value(value="${cudami.database.port}")
    private String databasePort;
    @Value(value="${cudami.database.username}")
    private String databaseUsername;
    @Value(value="${spring.flyway.enabled:true}")
    private boolean flywayEnabled;
    @Autowired
    ObjectMapper objectMapper;

    @Bean(initMethod="migrate")
    @Autowired
    @Qualifier(value="pds")
    public Flyway flyway(DataSource pds) {
        if (!this.flywayEnabled) {
            return null;
        }
        return Flyway.configure().dataSource(pds).locations(new String[]{"classpath:/de/digitalcollections/cudami/server/backend/impl/database/migration"}).baselineOnMigrate(true).outOfOrder(true).load();
    }

    @Bean
    @Autowired
    @Qualifier(value="pds")
    public PersistentTokenRepository persistentTokenRepository(DataSource pds) {
        JdbcTokenRepositoryImpl db = new JdbcTokenRepositoryImpl();
        db.setDataSource(pds);
        return db;
    }

    @Bean
    @DependsOn(value={"flyway"})
    @Autowired
    @Qualifier(value="ds")
    public JdbiFactoryBean jdbi(DataSource ds) throws Exception {
        JdbiFactoryBean jdbiFactoryBean = new JdbiFactoryBean(ds);
        ArrayList<Object> plugins = new ArrayList<Object>();
        plugins.add(new SqlObjectPlugin());
        plugins.add(new PostgresPlugin());
        plugins.add(new DcCommonsJdbiPlugin());
        plugins.add(new JsonbJdbiPlugin(this.objectMapper));
        jdbiFactoryBean.setPlugins(plugins);
        return jdbiFactoryBean;
    }

    @Bean(name={"ds"})
    @Primary
    public DataSource dataSource() {
        DriverManagerDataSource ds = new DriverManagerDataSource();
        ds.setDriverClassName("org.postgresql.Driver");
        ds.setUrl("jdbc:postgresql://" + this.databaseHostname + ":" + this.databasePort + "/" + this.databaseName);
        ds.setUsername(this.databaseUsername);
        ds.setPassword(this.databasePassword);
        ds.setConnectionProperties(this.getConnectionProperties());
        return ds;
    }

    private Properties getConnectionProperties() {
        Properties props = new Properties();
        props.put("tcpKeepAlive", "true");
        props.put("testOnBorrow", "true");
        props.put("testOnReturn", "true");
        props.put("testWhileIdle", "true");
        props.put("validationQuery", "SELECT 1");
        props.put("timeBetweenEvictionRunsMillis", "60000");
        props.put("numTestsPerEvictionRun", "3");
        props.put("minEvictableIdleTimeMillis", "1800000");
        return props;
    }

    @Bean(name={"pds"})
    @Autowired
    @Qualifier(value="ds")
    public DataSource pooledDataSource(DataSource ds) {
        ObjectPool<PoolableConnection> pool = this.getObjectPool(ds);
        PoolingDataSource pds = new PoolingDataSource(pool);
        return pds;
    }

    private ObjectPool<PoolableConnection> getObjectPool(DataSource ds) {
        PoolableConnectionFactory poolableConnectionFactory = this.getPoolableConnectionFactory(ds);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        return connectionPool;
    }

    private PoolableConnectionFactory getPoolableConnectionFactory(DataSource ds) {
        DataSourceConnectionFactory dataSourceConnectionFactory = this.getDataSourceConnectionFactory(ds);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)dataSourceConnectionFactory, null);
        poolableConnectionFactory.setValidationQuery("SELECT 1");
        long maxConnLifetimeMillis = 600000L;
        poolableConnectionFactory.setMaxConnLifetimeMillis(maxConnLifetimeMillis);
        return poolableConnectionFactory;
    }

    private DataSourceConnectionFactory getDataSourceConnectionFactory(DataSource ds) {
        DataSourceConnectionFactory dscf = new DataSourceConnectionFactory(ds);
        return dscf;
    }
}

