/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CollectionRepositoryImpl
extends EntityRepositoryImpl<de.digitalcollections.model.api.identifiable.entity.Collection>
implements CollectionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM collections as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM collections as c LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid";

    @Autowired
    public CollectionRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM collections";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection findOne(UUID uuid) {
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM collections as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid WHERE c.uuid = :uuid";
        CollectionImpl result = (CollectionImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                collection.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM collections as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                collection.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection save(de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        collection.setUuid(UUID.randomUUID());
        collection.setCreated(LocalDateTime.now());
        collection.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = collection.getPreviewImage() == null ? null : collection.getPreviewImage().getUuid();
        String query = "INSERT INTO collections(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, text) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)collection)).execute());
        Set identifiers = collection.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)collection);
        de.digitalcollections.model.api.identifiable.entity.Collection result = this.findOne(collection.getUuid());
        return result;
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection update(de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        collection.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = collection.getPreviewImage() == null ? null : collection.getPreviewImage().getUuid();
        String query = "UPDATE collections SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)collection)).execute());
        this.deleteIdentifiers((Identifiable)collection);
        Set identifiers = collection.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)collection);
        de.digitalcollections.model.api.identifiable.entity.Collection result = this.findOne(collection.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "c.created";
            }
            case "lastModified": {
                return "c.last_modified";
            }
            case "refId": {
                return "c.refid";
            }
        }
        return null;
    }
}

