/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.filter.enums.FilterOperation;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.api.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.identifiable.resource.TextFileResource;
import de.digitalcollections.model.api.identifiable.resource.VideoFileResource;
import de.digitalcollections.model.api.identifiable.resource.enums.FileResourceType;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.resource.ApplicationFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.AudioFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.LinkedDataFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.TextFileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.VideoFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.paging.SearchPageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FileResourceMetadataRepositoryImpl
extends IdentifiableRepositoryImpl<FileResource>
implements FileResourceMetadataRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.preview_hints f_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.preview_hints f_previewImageRenderingHints, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources as f LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid";

    @Autowired
    public FileResourceMetadataRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM fileresources";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public FileResource createByMimeType(MimeType mimeType) {
        AudioFileResourceImpl result;
        String primaryType;
        if (mimeType == null) {
            mimeType = MimeType.MIME_APPLICATION_OCTET_STREAM;
        }
        switch (primaryType = mimeType.getPrimaryType()) {
            case "audio": {
                result = new AudioFileResourceImpl();
                break;
            }
            case "image": {
                result = new ImageFileResourceImpl();
                break;
            }
            case "text": {
                result = new TextFileResourceImpl();
                break;
            }
            case "video": {
                result = new VideoFileResourceImpl();
                break;
            }
            case "application": {
                if ("ld+json".equals(mimeType.getSubType())) {
                    result = new LinkedDataFileResourceImpl();
                    break;
                }
                result = new ApplicationFileResourceImpl();
                break;
            }
            default: {
                result = new ApplicationFileResourceImpl();
            }
        }
        result.setMimeType(mimeType);
        UUID uuid = UUID.randomUUID();
        result.setUuid(uuid);
        return result;
    }

    @Override
    public PageResponse<FileResource> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            FileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (FileResourceImpl)rowView.getRow(FileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public SearchPageResponse<FileResource> find(SearchPageRequest searchPageRequest) {
        FilterCriterion fileResourceTypeCriterion;
        StringBuilder query = new StringBuilder("SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.preview_hints f_previewImageRenderingHints, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources as f LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid LEFT JOIN LATERAL jsonb_object_keys(f.label) l(keys) on f.label is not null LEFT JOIN LATERAL jsonb_object_keys(f.description) d(keys) on f.description is not null WHERE (f.label->>l.keys ilike '%' || :searchTerm || '%' OR f.description->>d.keys ilike '%' || :searchTerm || '%' OR f.filename ilike '%' || :searchTerm || '%')");
        String filterQuery = "";
        Filtering filtering = searchPageRequest.getFiltering();
        if (filtering != null && FilterOperation.EQUALS == (fileResourceTypeCriterion = filtering.getFilterCriterionFor("fileResourceType")).getOperation()) {
            FileResourceType fileResourceType = (FileResourceType)fileResourceTypeCriterion.getValue();
            switch (fileResourceType) {
                case IMAGE: {
                    filterQuery = " AND f.mimetype ilike 'image/%'";
                    query.append(filterQuery);
                    break;
                }
            }
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchPageRequest.getQuery())).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            FileResource fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), uuid -> (FileResource)rowView.getRow(FileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", String.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(*) FROM fileresources as f LEFT JOIN LATERAL jsonb_object_keys(f.label) l(keys) on f.label is not null LEFT JOIN LATERAL jsonb_object_keys(f.description) d(keys) on f.description is not null WHERE (f.label->>l.keys ilike '%' || :searchTerm || '%' OR f.description->>d.keys ilike '%' || :searchTerm || '%' OR f.filename ilike '%' || :searchTerm || '%')" + filterQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("searchTerm", searchPageRequest.getQuery())).mapTo(Long.class).findOne().get());
        SearchPageResponseImpl pageResponse = new SearchPageResponseImpl(result, searchPageRequest, total);
        return pageResponse;
    }

    @Override
    public FileResource findOne(UUID uuid) {
        String query = "SELECT mimetype FROM fileresources WHERE uuid=:uuid";
        String mimetype = (String)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", (Object)uuid)).mapTo(String.class).findOne().orElse(null));
        if (mimetype == null) {
            return null;
        }
        FileResource typedFileResource = this.createByMimeType(MimeType.fromTypename((String)mimetype));
        if (typedFileResource instanceof ApplicationFileResource) {
            return this.findOneApplicationFileResource(uuid);
        }
        if (typedFileResource instanceof AudioFileResource) {
            return this.findOneAudioFileResource(uuid);
        }
        if (typedFileResource instanceof ImageFileResource) {
            return this.findOneImageFileResource(uuid);
        }
        if (typedFileResource instanceof LinkedDataFileResource) {
            return this.findOneLinkedDataFileResource(uuid);
        }
        if (typedFileResource instanceof TextFileResource) {
            return this.findOneTextFileResource(uuid);
        }
        if (typedFileResource instanceof VideoFileResource) {
            return this.findOneVideoFileResource(uuid);
        }
        return null;
    }

    @Override
    public FileResource findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT f.uuid f_uuid FROM fileresources as f LEFT JOIN identifiers as id on f.uuid = id.identifiable WHERE id.identifier = :id AND id.namespace = :namespace";
        String id = identifier.getId();
        UUID uuid = (UUID)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query).bind("id", id)).bind("namespace", namespace)).mapTo(UUID.class).findOne().orElse(null));
        if (uuid == null) {
            return null;
        }
        return this.findOne(uuid);
    }

    private ApplicationFileResource findOneApplicationFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_application as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        ApplicationFileResourceImpl result = (ApplicationFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ApplicationFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ApplicationFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (ApplicationFileResourceImpl)rowView.getRow(ApplicationFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    private AudioFileResource findOneAudioFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.duration f_duration, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_audio as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        AudioFileResourceImpl result = (AudioFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(AudioFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            AudioFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (AudioFileResourceImpl)rowView.getRow(AudioFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    private ImageFileResource findOneImageFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.height f_height, f.width f_width, f.iiif_base_url f_iiifBaseUrl, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_image as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        ImageFileResourceImpl result = (ImageFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ImageFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (ImageFileResourceImpl)rowView.getRow(ImageFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    private LinkedDataFileResource findOneLinkedDataFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.context f_context, f.object_type f_objectType, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_linkeddata as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        LinkedDataFileResourceImpl result = (LinkedDataFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(LinkedDataFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            LinkedDataFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (LinkedDataFileResourceImpl)rowView.getRow(LinkedDataFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    private TextFileResource findOneTextFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_text as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        TextFileResourceImpl result = (TextFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(TextFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            TextFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (TextFileResourceImpl)rowView.getRow(TextFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    private VideoFileResource findOneVideoFileResource(UUID uuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.description f_description, f.identifiable_type f_type, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimetype, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.duration f_duration, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM fileresources_video as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid WHERE f.uuid = :uuid";
        VideoFileResourceImpl result = (VideoFileResourceImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(VideoFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            VideoFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (VideoFileResourceImpl)rowView.getRow(VideoFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public FileResource save(FileResource fileResource) {
        if (fileResource.getUuid() == null) {
            fileResource.setUuid(UUID.randomUUID());
        }
        fileResource.setCreated(LocalDateTime.now());
        fileResource.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = fileResource.getPreviewImage() == null ? null : fileResource.getPreviewImage().getUuid();
        String baseColumnsSql = "uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri";
        String basePropertiesSql = ":uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri";
        if (fileResource instanceof ApplicationFileResource) {
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_application(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof AudioFileResource) {
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_audio(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof ImageFileResource) {
            UUID previewUuid = previewImageUuid == null ? fileResource.getUuid() : previewImageUuid;
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_image(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri, width, height, iiif_base_url) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :width, :height, :iiifBaseUrl)").bind("previewFileResource", (Object)previewUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof LinkedDataFileResource) {
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_linkeddata(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri, context, object_type) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :context, :objectType)").bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof TextFileResource) {
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_text(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri)").bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof VideoFileResource) {
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("INSERT INTO fileresources_video(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, filename, mimetype, size_in_bytes, uri, duration) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :filename, :mimeType, :sizeInBytes, :uri, :duration)").bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        Set identifiers = fileResource.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)fileResource);
        FileResource result = this.findOne(fileResource.getUuid());
        return result;
    }

    @Override
    public FileResource update(FileResource fileResource) {
        String query;
        fileResource.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = fileResource.getPreviewImage() == null ? null : fileResource.getPreviewImage().getUuid();
        String baseColumnsSql = "label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified";
        if (fileResource instanceof ApplicationFileResource) {
            query = "UPDATE fileresources_application SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof AudioFileResource) {
            query = "UPDATE fileresources_audio SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, duration=:duration WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof ImageFileResource) {
            UUID previewUuid = previewImageUuid == null ? fileResource.getUuid() : previewImageUuid;
            String query2 = "UPDATE fileresources_image SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, width=:width, height=:height, iiif_base_url=:iiifBaseUrl WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query2).bind("previewFileResource", (Object)previewUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof LinkedDataFileResource) {
            query = "UPDATE fileresources_linkeddata SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, context=:context, object_type=:objectType WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof TextFileResource) {
            query = "UPDATE fileresources_text SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else if (fileResource instanceof VideoFileResource) {
            query = "UPDATE fileresources_video SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, duration=:duration WHERE uuid=:uuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)fileResource)).execute());
        } else {
            throw new IllegalArgumentException("unknown file resource type " + fileResource.getMimeType().toString());
        }
        this.deleteIdentifiers((Identifiable)fileResource);
        Set identifiers = fileResource.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)fileResource);
        FileResource result = this.findOne(fileResource.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "filename", "lastModified", "sizeInBytes"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "f.created";
            }
            case "filename": {
                return "f.filename";
            }
            case "lastModified": {
                return "f.last_modified";
            }
            case "sizeInBytes": {
                return "f.size_in_bytes";
            }
        }
        return null;
    }
}

