/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.AbstractPagingAndSortingRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.paging.SearchPageResponseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends AbstractPagingAndSortingRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT i.uuid i_uuid, i.label i_label, i.description i_description, i.identifiable_type i_type, i.created i_created, i.last_modified i_last_modified, i.preview_hints i_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM identifiables as i LEFT JOIN identifiers as id on i.uuid = id.identifiable LEFT JOIN fileresources_image as file on i.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT i.uuid i_uuid, i.label i_label, i.description i_description, i.identifiable_type i_type, i.created i_created, i.last_modified i_lastModified, i.preview_hints i_previewImageRenderingHints, file.uuid f_uuid, file.uri f_uri, file.filename f_filename, file.iiif_base_url f_iiifBaseUrl FROM identifiables as i LEFT JOIN fileresources_image as file on i.previewfileresource = file.uuid";
    protected Jdbi dbi;
    protected final IdentifierRepository identifierRepository;

    @Autowired
    public IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        this.dbi = dbi;
        this.identifierRepository = identifierRepository;
    }

    public long count() {
        String sql = "SELECT count(*) FROM identifiables";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    protected void deleteIdentifiers(Identifiable identifiable) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM identifiers WHERE identifiable = :uuid").bind("uuid", (Object)identifiable.getUuid())).execute());
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(IdentifiableImpl.class, (String)"i"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            IdentifiableImpl identifiable = map.computeIfAbsent((UUID)rowView.getColumn("i_uuid", UUID.class), fn -> (IdentifiableImpl)rowView.getRow(IdentifiableImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                identifiable.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public SearchPageResponse<I> find(SearchPageRequest searchPageRequest) {
        Sorting sorting = Sorting.defaultBuilder().order((Order)new OrderImpl(Direction.DESC, "lastModified")).build();
        searchPageRequest.setSorting(sorting);
        StringBuilder query = new StringBuilder("SELECT i.uuid i_uuid, i.label i_label, i.description i_description, i.identifiable_type i_identifiableType, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM identifiables as i LEFT JOIN fileresources_image as file on i.previewfileresource = file.uuid LEFT JOIN LATERAL jsonb_object_keys(i.label) l(keys) on i.label is not null LEFT JOIN LATERAL jsonb_object_keys(i.description) d(keys) on i.description is not null WHERE (i.label->>l.keys ilike '%' || :searchTerm || '%' OR i.description->>d.keys ilike '%' || :searchTerm || '%')");
        this.addPageRequestParams((PageRequest)searchPageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchPageRequest.getQuery())).registerRowMapper(BeanMapper.factory(IdentifiableImpl.class, (String)"i"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Identifiable identifiable = map.computeIfAbsent((UUID)rowView.getColumn("i_uuid", UUID.class), uuid -> (Identifiable)rowView.getRow(IdentifiableImpl.class));
            if (rowView.getColumn("f_uri", String.class) != null) {
                identifiable.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(*) FROM identifiables as i LEFT JOIN LATERAL jsonb_object_keys(i.label) l(keys) on i.label is not null LEFT JOIN LATERAL jsonb_object_keys(i.description) d(keys) on i.description is not null WHERE (i.label->>l.keys ilike '%' || :searchTerm || '%' OR i.description->>d.keys ilike '%' || :searchTerm || '%')";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("searchTerm", searchPageRequest.getQuery())).mapTo(Long.class).findOne().get());
        SearchPageResponseImpl pageResponse = new SearchPageResponseImpl(result, searchPageRequest, total);
        return pageResponse;
    }

    public List<I> find(String searchTerm, int maxResults) {
        StringBuilder query = new StringBuilder("SELECT uuid, label, description, identifiable_type FROM identifiables WHERE (label::text) ILIKE '%' || :searchTerm || '%'");
        query.append(" LIMIT :maxResults");
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchTerm)).bind("maxResults", maxResults)).mapToBean(IdentifiableImpl.class).stream().map(s -> s).collect(Collectors.toList()));
        return result;
    }

    public I findOne(UUID uuid) {
        String query = "SELECT i.uuid i_uuid, i.label i_label, i.description i_description, i.identifiable_type i_type, i.created i_created, i.last_modified i_last_modified, i.preview_hints i_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM identifiables as i LEFT JOIN identifiers as id on i.uuid = id.identifiable LEFT JOIN fileresources_image as file on i.previewfileresource = file.uuid WHERE i.uuid = :uuid";
        IdentifiableImpl result = (IdentifiableImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(IdentifiableImpl.class, (String)"i"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            IdentifiableImpl identifiable = map.computeIfAbsent((UUID)rowView.getColumn("i_uuid", UUID.class), fn -> (IdentifiableImpl)rowView.getRow(IdentifiableImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                identifiable.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                identifiable.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return (I)result;
    }

    public I findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT i.uuid i_uuid, i.label i_label, i.description i_description, i.identifiable_type i_type, i.created i_created, i.last_modified i_last_modified, i.preview_hints i_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM identifiables as i LEFT JOIN identifiers as id on i.uuid = id.identifiable LEFT JOIN fileresources_image as file on i.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(IdentifiableImpl.class, (String)"i"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            IdentifiableImpl identifiable = map.computeIfAbsent((UUID)rowView.getColumn("i_uuid", UUID.class), fn -> (IdentifiableImpl)rowView.getRow(IdentifiableImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                identifiable.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                identifiable.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        return (I)((Identifiable)result.orElse(null));
    }

    public I findOneByIdentifier(String namespace, String id) {
        return this.findOne((Identifier)new IdentifierImpl(null, namespace, id));
    }

    public I save(I identifiable) {
        throw new UnsupportedOperationException("use save of specific/inherited identifiable repository");
    }

    protected void saveIdentifiers(Set<Identifier> identifiers, Identifiable identifiable) {
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(identifiable.getUuid());
                this.identifierRepository.save(identifier);
            }
        }
    }

    public I update(I identifiable) {
        throw new UnsupportedOperationException("use update of specific/inherited identifiable repository");
    }

    protected Integer selectNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT MAX(sortIndex) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", (Object)parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        if (sortIndex == null) {
            return 0;
        }
        return sortIndex;
    }

    protected int getIndex(List<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        for (Identifiable identifiable2 : list) {
            ++pos;
            if (!identifiable2.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "type"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "i.created";
            }
            case "lastModified": {
                return "i.last_modified";
            }
            case "type": {
                return "i.identifiable_type";
            }
        }
        return null;
    }
}

