/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.ArticleImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl
extends EntityRepositoryImpl<Article>
implements ArticleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticleRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM articles as a LEFT JOIN identifiers as id on a.uuid = id.identifiable LEFT JOIN fileresources_image as file on a.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.preview_hints a_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM articles as a LEFT JOIN fileresources_image as file on a.previewfileresource = file.uuid";

    @Autowired
    public ArticleRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM articles";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Article> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Article findOne(UUID uuid) {
        String query = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM articles as a LEFT JOIN identifiers as id on a.uuid = id.identifiable LEFT JOIN fileresources_image as file on a.previewfileresource = file.uuid WHERE a.uuid = :uuid";
        ArticleImpl result = (ArticleImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                article.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public Article findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM articles as a LEFT JOIN identifiers as id on a.uuid = id.identifiable LEFT JOIN fileresources_image as file on a.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                article.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    @Override
    public Article save(Article article) {
        article.setUuid(UUID.randomUUID());
        article.setCreated(LocalDateTime.now());
        article.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = article.getPreviewImage() == null ? null : article.getPreviewImage().getUuid();
        String query = "INSERT INTO articles(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, text) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)article)).execute());
        Set identifiers = article.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)article);
        Article result = this.findOne(article.getUuid());
        return result;
    }

    @Override
    public Article update(Article article) {
        article.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = article.getPreviewImage() == null ? null : article.getPreviewImage().getUuid();
        String query = "UPDATE articles SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)article)).execute());
        this.deleteIdentifiers((Identifiable)article);
        Set identifiers = article.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)article);
        Article result = this.findOne(article.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "a.created";
            }
            case "lastModified": {
                return "a.last_modified";
            }
            case "refId": {
                return "a.refid";
            }
        }
        return null;
    }
}

