/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.TopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.TopicImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.SubtopicImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TopicRepositoryImpl
extends EntityRepositoryImpl<Topic>
implements TopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT t.uuid t_uuid, t.refid t_refId, t.label t_label, t.description t_description, t.identifiable_type t_type, t.entity_type t_entityType, t.created t_created, t.last_modified t_lastModified, t.preview_hints t_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM topics as t LEFT JOIN identifiers as id on t.uuid = id.identifiable LEFT JOIN fileresources_image as file on t.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT t.uuid t_uuid, t.refid t_refId, t.label t_label, t.description t_description, t.identifiable_type t_type, t.entity_type t_entityType, t.created t_created, t.last_modified t_lastModified, t.preview_hints t_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM topics as t LEFT JOIN fileresources_image as file on t.previewfileresource = file.uuid";

    @Autowired
    public TopicRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM topics";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Topic> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(TopicImpl.class, (String)"t"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            TopicImpl topic = map.computeIfAbsent((UUID)rowView.getColumn("t_uuid", UUID.class), fn -> (TopicImpl)rowView.getRow(TopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                topic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Topic findOne(UUID uuid) {
        String query = "SELECT t.uuid t_uuid, t.refid t_refId, t.label t_label, t.description t_description, t.identifiable_type t_type, t.entity_type t_entityType, t.created t_created, t.last_modified t_lastModified, t.preview_hints t_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM topics as t LEFT JOIN identifiers as id on t.uuid = id.identifiable LEFT JOIN fileresources_image as file on t.previewfileresource = file.uuid WHERE t.uuid = :uuid";
        TopicImpl result = (TopicImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(TopicImpl.class, (String)"t"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            TopicImpl topic = map.computeIfAbsent((UUID)rowView.getColumn("t_uuid", UUID.class), fn -> (TopicImpl)rowView.getRow(TopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                topic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                topic.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            result.setSubtopics(this.getSubtopics((Topic)result));
        }
        return result;
    }

    @Override
    public Topic findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT t.uuid t_uuid, t.refid t_refId, t.label t_label, t.description t_description, t.identifiable_type t_type, t.entity_type t_entityType, t.created t_created, t.last_modified t_lastModified, t.preview_hints t_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM topics as t LEFT JOIN identifiers as id on t.uuid = id.identifiable LEFT JOIN fileresources_image as file on t.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(TopicImpl.class, (String)"t"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            TopicImpl topic = map.computeIfAbsent((UUID)rowView.getColumn("t_uuid", UUID.class), fn -> (TopicImpl)rowView.getRow(TopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                topic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                topic.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        Topic topic = result.orElse(null);
        if (topic != null) {
            topic.setSubtopics(this.getSubtopics(topic));
        }
        return topic;
    }

    public List<Subtopic> getSubtopics(Topic topic) {
        UUID uuid = topic.getUuid();
        return this.getSubtopics(uuid);
    }

    public List<Subtopic> getSubtopics(UUID uuid) {
        String query = "SELECT st.uuid st_uuid, st.label st_label, st.description st_description, st.identifiable_type st_type, st.created st_created, st.last_modified st_lastModified, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM subtopics as st INNER JOIN topic_subtopics ts ON st.uuid = ts.subtopic_uuid LEFT JOIN fileresources_image as file on st.previewfileresource = file.uuid WHERE ts.topic_uuid = :uuid ORDER BY ts.sortIndex ASC";
        ArrayList<Subtopic> result = new ArrayList<Subtopic>((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(SubtopicImpl.class, (String)"st"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            SubtopicImpl subtopic = map.computeIfAbsent((UUID)rowView.getColumn("st_uuid", UUID.class), fn -> (SubtopicImpl)rowView.getRow(SubtopicImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                subtopic.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        return result;
    }

    @Override
    public Topic save(Topic topic) {
        topic.setUuid(UUID.randomUUID());
        topic.setCreated(LocalDateTime.now());
        topic.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = topic.getPreviewImage() == null ? null : topic.getPreviewImage().getUuid();
        String query = "INSERT INTO topics(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)topic)).execute());
        Set identifiers = topic.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)topic);
        Topic result = this.findOne(topic.getUuid());
        return result;
    }

    @Override
    public Topic update(Topic topic) {
        topic.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = topic.getPreviewImage() == null ? null : topic.getPreviewImage().getUuid();
        String query = "UPDATE topics SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)topic)).execute());
        this.deleteIdentifiers((Identifiable)topic);
        Set identifiers = topic.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)topic);
        Topic result = this.findOne(topic.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "t.created";
            }
            case "lastModified": {
                return "t.last_modified";
            }
            case "refId": {
                return "t.refid";
            }
        }
        return null;
    }
}

